/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluid_cloudnative.fluid;

import com.github.fluid_cloudnative.fluid.JindoCompTemplateSpec;
import com.github.fluid_cloudnative.fluid.JindoFuseSpec;
import com.github.fluid_cloudnative.fluid.Tieredstore;
import com.github.fluid_cloudnative.fluid.User;
import com.github.fluid_cloudnative.fluid.VersionSpec;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="JindoRuntimeSpec defines the desired state of JindoRuntime")
public class JindoRuntimeSpec {
    @SerializedName(value="fuse")
    private JindoFuseSpec fuse = null;
    @SerializedName(value="hadoopConfig")
    private String hadoopConfig = null;
    @SerializedName(value="jindoVersion")
    private VersionSpec jindoVersion = null;
    @SerializedName(value="master")
    private JindoCompTemplateSpec master = null;
    @SerializedName(value="properties")
    private Map<String, String> properties = null;
    @SerializedName(value="replicas")
    private Integer replicas = null;
    @SerializedName(value="runAs")
    private User runAs = null;
    @SerializedName(value="secret")
    private String secret = null;
    @SerializedName(value="tieredstore")
    private Tieredstore tieredstore = null;
    @SerializedName(value="user")
    private String user = null;
    @SerializedName(value="worker")
    private JindoCompTemplateSpec worker = null;

    public JindoRuntimeSpec fuse(JindoFuseSpec fuse) {
        this.fuse = fuse;
        return this;
    }

    @ApiModelProperty(value="Desired state for Jindo Fuse")
    public JindoFuseSpec getFuse() {
        return this.fuse;
    }

    public void setFuse(JindoFuseSpec fuse) {
        this.fuse = fuse;
    }

    public JindoRuntimeSpec hadoopConfig(String hadoopConfig) {
        this.hadoopConfig = hadoopConfig;
        return this;
    }

    @ApiModelProperty(value="Name of the configMap used to support HDFS configurations when using HDFS as Jindo's UFS. The configMap must be in the same namespace with the JindoRuntime. The configMap should contain user-specific HDFS conf files in it. For now, only \"hdfs-site.xml\" and \"core-site.xml\" are supported. It must take the filename of the conf file as the key and content of the file as the value.")
    public String getHadoopConfig() {
        return this.hadoopConfig;
    }

    public void setHadoopConfig(String hadoopConfig) {
        this.hadoopConfig = hadoopConfig;
    }

    public JindoRuntimeSpec jindoVersion(VersionSpec jindoVersion) {
        this.jindoVersion = jindoVersion;
        return this;
    }

    @ApiModelProperty(value="The version information that instructs fluid to orchestrate a particular version of Jindo.")
    public VersionSpec getJindoVersion() {
        return this.jindoVersion;
    }

    public void setJindoVersion(VersionSpec jindoVersion) {
        this.jindoVersion = jindoVersion;
    }

    public JindoRuntimeSpec master(JindoCompTemplateSpec master) {
        this.master = master;
        return this;
    }

    @ApiModelProperty(value="Desired state for Jindo master")
    public JindoCompTemplateSpec getMaster() {
        return this.master;
    }

    public void setMaster(JindoCompTemplateSpec master) {
        this.master = master;
    }

    public JindoRuntimeSpec properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public JindoRuntimeSpec putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @ApiModelProperty(value="Configurable properties for Jindo system. <br>")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public JindoRuntimeSpec replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @ApiModelProperty(value="The replicas of the worker, need to be specified")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public JindoRuntimeSpec runAs(User runAs) {
        this.runAs = runAs;
        return this;
    }

    @ApiModelProperty(value="Manage the user to run Jindo Runtime")
    public User getRunAs() {
        return this.runAs;
    }

    public void setRunAs(User runAs) {
        this.runAs = runAs;
    }

    public JindoRuntimeSpec secret(String secret) {
        this.secret = secret;
        return this;
    }

    @ApiModelProperty(value="")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public JindoRuntimeSpec tieredstore(Tieredstore tieredstore) {
        this.tieredstore = tieredstore;
        return this;
    }

    @ApiModelProperty(value="Tiered storage used by Jindo")
    public Tieredstore getTieredstore() {
        return this.tieredstore;
    }

    public void setTieredstore(Tieredstore tieredstore) {
        this.tieredstore = tieredstore;
    }

    public JindoRuntimeSpec user(String user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(value="")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public JindoRuntimeSpec worker(JindoCompTemplateSpec worker) {
        this.worker = worker;
        return this;
    }

    @ApiModelProperty(value="Desired state for Jindo worker")
    public JindoCompTemplateSpec getWorker() {
        return this.worker;
    }

    public void setWorker(JindoCompTemplateSpec worker) {
        this.worker = worker;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JindoRuntimeSpec jindoRuntimeSpec = (JindoRuntimeSpec)o;
        return Objects.equals(this.fuse, jindoRuntimeSpec.fuse) && Objects.equals(this.hadoopConfig, jindoRuntimeSpec.hadoopConfig) && Objects.equals(this.jindoVersion, jindoRuntimeSpec.jindoVersion) && Objects.equals(this.master, jindoRuntimeSpec.master) && Objects.equals(this.properties, jindoRuntimeSpec.properties) && Objects.equals(this.replicas, jindoRuntimeSpec.replicas) && Objects.equals(this.runAs, jindoRuntimeSpec.runAs) && Objects.equals(this.secret, jindoRuntimeSpec.secret) && Objects.equals(this.tieredstore, jindoRuntimeSpec.tieredstore) && Objects.equals(this.user, jindoRuntimeSpec.user) && Objects.equals(this.worker, jindoRuntimeSpec.worker);
    }

    public int hashCode() {
        return Objects.hash(this.fuse, this.hadoopConfig, this.jindoVersion, this.master, this.properties, this.replicas, this.runAs, this.secret, this.tieredstore, this.user, this.worker);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JindoRuntimeSpec {\n");
        sb.append("    fuse: ").append(this.toIndentedString(this.fuse)).append("\n");
        sb.append("    hadoopConfig: ").append(this.toIndentedString(this.hadoopConfig)).append("\n");
        sb.append("    jindoVersion: ").append(this.toIndentedString(this.jindoVersion)).append("\n");
        sb.append("    master: ").append(this.toIndentedString(this.master)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    runAs: ").append(this.toIndentedString(this.runAs)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    tieredstore: ").append(this.toIndentedString(this.tieredstore)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    worker: ").append(this.toIndentedString(this.worker)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

