/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluid_cloudnative.fluid;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.proto.V1;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Level describes configurations a tier needs. <br> Refer to <a href=\"https://docs.alluxio.io/os/user/stable/en/core-services/Caching.html#configuring-tiered-storage\">Configuring Tiered Storage</a> for more info")
public class Level {
    @SerializedName(value="high")
    private String high = null;
    @SerializedName(value="low")
    private String low = null;
    @SerializedName(value="mediumtype")
    private String mediumtype = null;
    @SerializedName(value="path")
    private String path = null;
    @SerializedName(value="quota")
    private V1.ResourceQuota quota = null;
    @SerializedName(value="quotaList")
    private String quotaList = null;

    public Level high(String high) {
        this.high = high;
        return this;
    }

    @ApiModelProperty(value="Ratio of high watermark of the tier (e.g. 0.9)")
    public String getHigh() {
        return this.high;
    }

    public void setHigh(String high) {
        this.high = high;
    }

    public Level low(String low) {
        this.low = low;
        return this;
    }

    @ApiModelProperty(value="Ratio of low watermark of the tier (e.g. 0.7)")
    public String getLow() {
        return this.low;
    }

    public void setLow(String low) {
        this.low = low;
    }

    public Level mediumtype(String mediumtype) {
        this.mediumtype = mediumtype;
        return this;
    }

    @ApiModelProperty(required=true, value="Medium Type of the tier. One of the three types: `MEM`, `SSD`, `HDD`")
    public String getMediumtype() {
        return this.mediumtype;
    }

    public void setMediumtype(String mediumtype) {
        this.mediumtype = mediumtype;
    }

    public Level path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(value="File paths to be used for the tier. Multiple paths are supported. Multiple paths should be separated with comma. For example: \"/mnt/cache1,/mnt/cache2\".")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Level quota(V1.ResourceQuota quota) {
        this.quota = quota;
        return this;
    }

    @ApiModelProperty(value="Quota for the whole tier. (e.g. 100Gi) Please note that if there're multiple paths used for this tierstore, the quota will be equally divided into these paths. If you'd like to set quota for each, path, see QuotaList for more information.")
    public V1.ResourceQuota getQuota() {
        return this.quota;
    }

    public void setQuota(V1.ResourceQuota quota) {
        this.quota = quota;
    }

    public Level quotaList(String quotaList) {
        this.quotaList = quotaList;
        return this;
    }

    @ApiModelProperty(value="QuotaList are quotas used to set quota on multiple paths. Quotas should be separated with comma. Quotas in this list will be set to paths with the same order in Path. For example, with Path defined with \"/mnt/cache1,/mnt/cache2\" and QuotaList set to \"100Gi, 50Gi\", then we get 100GiB cache storage under \"/mnt/cache1\" and 50GiB under \"/mnt/cache2\". Also note that num of quotas must be consistent with the num of paths defined in Path.")
    public String getQuotaList() {
        return this.quotaList;
    }

    public void setQuotaList(String quotaList) {
        this.quotaList = quotaList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Level level = (Level)o;
        return Objects.equals(this.high, level.high) && Objects.equals(this.low, level.low) && Objects.equals(this.mediumtype, level.mediumtype) && Objects.equals(this.path, level.path) && Objects.equals(this.quota, level.quota) && Objects.equals(this.quotaList, level.quotaList);
    }

    public int hashCode() {
        return Objects.hash(this.high, this.low, this.mediumtype, this.path, this.quota, this.quotaList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Level {\n");
        sb.append("    high: ").append(this.toIndentedString(this.high)).append("\n");
        sb.append("    low: ").append(this.toIndentedString(this.low)).append("\n");
        sb.append("    mediumtype: ").append(this.toIndentedString(this.mediumtype)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    quota: ").append(this.toIndentedString(this.quota)).append("\n");
        sb.append("    quotaList: ").append(this.toIndentedString(this.quotaList)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

