/*
 * Decompiled with CFR 0.152.
 */
package com.github.fluid_cloudnative.fluid;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.proto.Meta;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Condition describes the state of the cache at a certain point.")
public class RuntimeCondition {
    @SerializedName(value="lastProbeTime")
    private Meta.Time lastProbeTime = null;
    @SerializedName(value="lastTransitionTime")
    private Meta.Time lastTransitionTime = null;
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="reason")
    private String reason = null;
    @SerializedName(value="status")
    private String status = null;
    @SerializedName(value="type")
    private String type = null;

    public RuntimeCondition lastProbeTime(Meta.Time lastProbeTime) {
        this.lastProbeTime = lastProbeTime;
        return this;
    }

    @ApiModelProperty(value="The last time this condition was updated.")
    public Meta.Time getLastProbeTime() {
        return this.lastProbeTime;
    }

    public void setLastProbeTime(Meta.Time lastProbeTime) {
        this.lastProbeTime = lastProbeTime;
    }

    public RuntimeCondition lastTransitionTime(Meta.Time lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
        return this;
    }

    @ApiModelProperty(value="Last time the condition transitioned from one status to another.")
    public Meta.Time getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    public void setLastTransitionTime(Meta.Time lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
    }

    public RuntimeCondition message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(value="A human readable message indicating details about the transition.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public RuntimeCondition reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="The reason for the condition's last transition.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public RuntimeCondition status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="Status of the condition, one of True, False, Unknown.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public RuntimeCondition type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Type of cache condition.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuntimeCondition runtimeCondition = (RuntimeCondition)o;
        return Objects.equals(this.lastProbeTime, runtimeCondition.lastProbeTime) && Objects.equals(this.lastTransitionTime, runtimeCondition.lastTransitionTime) && Objects.equals(this.message, runtimeCondition.message) && Objects.equals(this.reason, runtimeCondition.reason) && Objects.equals(this.status, runtimeCondition.status) && Objects.equals(this.type, runtimeCondition.type);
    }

    public int hashCode() {
        return Objects.hash(this.lastProbeTime, this.lastTransitionTime, this.message, this.reason, this.status, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RuntimeCondition {\n");
        sb.append("    lastProbeTime: ").append(this.toIndentedString(this.lastProbeTime)).append("\n");
        sb.append("    lastTransitionTime: ").append(this.toIndentedString(this.lastTransitionTime)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

