/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.javajsonutils;

import ch.framedev.javajsonutils.JsonUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;

public class JsonConfigurator {
    private HashMap<String, Object> data;
    private File file;

    public JsonConfigurator(File file) {
        this.file = file;
        this.getConfig();
    }

    public void setFile(File file) {
        this.file = file;
        this.getConfig();
    }

    public HashMap<String, Object> getData() {
        return this.data;
    }

    private HashMap<String, Object> getConfig() {
        HashMap hash = new HashMap();
        try {
            return new JsonUtils().getHashMapFromJsonFile(this.file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.data = hash;
            return this.data;
        }
    }

    public void setDefaults(HashMap<String, Object> defaults) {
        this.data = this.getConfig();
        this.data.putAll(defaults);
    }

    public void addDefault(String path, Object value) {
        this.data = this.getConfig();
        if (!this.isSet(path)) {
            this.data.put(path, value);
        }
    }

    public void set(String path, Object value) {
        if (this.data == null) {
            this.data = this.getConfig();
        }
        if (value == null) {
            this.data.remove(path);
        } else {
            this.data.put(path, value);
        }
    }

    public int getInt(String path) {
        this.data = this.getConfig();
        if (this.data.containsKey(path)) {
            return Integer.parseInt(String.valueOf(this.data.get(path)));
        }
        return 0;
    }

    public double getDouble(String path) {
        this.data = this.getConfig();
        if (this.data.containsKey(path)) {
            return Double.parseDouble(String.valueOf(this.data.get(path)));
        }
        return 0.0;
    }

    public Object get(String path) {
        this.data = this.getConfig();
        if (this.data.containsKey(path)) {
            return this.data.get(path);
        }
        return null;
    }

    public List<String> getStringList(String path) {
        this.data = this.getConfig();
        if (this.data.containsKey(path)) {
            return (List)this.data.get(path);
        }
        return null;
    }

    public List<Object> getList(String path) {
        this.data = this.getConfig();
        if (this.data.containsKey(path)) {
            return (List)this.data.get(path);
        }
        return null;
    }

    public String getString(String path) {
        this.data = this.getConfig();
        if (this.data.containsKey(path)) {
            return (String)this.data.get(path);
        }
        return null;
    }

    public boolean getBoolean(String path) {
        this.data = this.getConfig();
        if (this.data.containsKey(path)) {
            return Boolean.parseBoolean(String.valueOf(this.data.get(path)));
        }
        return false;
    }

    public boolean isInteger(String path) {
        this.data = this.getConfig();
        if (this.data.containsKey(path)) {
            try {
                Integer.parseInt(String.valueOf(this.data.get(path)));
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isDouble(String path) {
        this.data = this.getConfig();
        if (this.data.containsKey(path)) {
            try {
                Double.parseDouble(String.valueOf(this.data.get(path)));
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean contains(String path) {
        this.data = this.getConfig();
        return this.data.containsKey(path);
    }

    public boolean isSet(String path) {
        this.data = this.getConfig();
        if (this.data.get(path) != null) {
            return this.data.containsKey(path);
        }
        return false;
    }

    public void saveDefaultConfig(Class<?> clazz, String resource) {
        InputStream is = clazz.getResourceAsStream(resource + ".json");
        HashMap<String, Object> hash = new HashMap();
        try {
            hash = new JsonUtils().getHashMapFromJsonFile(is);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (is != null) {
            try {
                new JsonUtils().saveHashMapToJson(this.file, hash);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.data != null && !this.data.isEmpty()) {
            hash.putAll(this.data);
        }
        this.data = hash;
    }

    public void saveConfig() {
        try {
            new JsonUtils().saveHashMapToJson(this.file, this.data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.data = this.getConfig();
    }

    public String toString() {
        return "JsonConfigurator{data=" + this.data + ", file=" + this.file + '}';
    }
}

