/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.javajsonutils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;

public class JsonUtils {
    public String objectToJsonString(Object object) {
        return new Gson().toJson(object);
    }

    public Object objectFromJsonString(String json) {
        return new Gson().fromJson(json, Object.class);
    }

    public <T> T classFromJsonString(String json, Class<T> class_) {
        return new Gson().fromJson(json, class_);
    }

    public Object getObjectFromJsonFile(File file) {
        if (file.exists()) {
            try {
                return new Gson().fromJson((Reader)new FileReader(file), Object.class);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean saveJsonToFile(File file, Object o) throws IOException {
        if (!file.exists()) {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            try {
                if (!file.createNewFile()) {
                    return false;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(new GsonBuilder().setPrettyPrinting().serializeNulls().create().toJson(o));
            writer.flush();
            writer.close();
            return true;
        }
        catch (IOException ex) {
            throw new IOException(ex);
        }
    }

    public <T> T getClassFromJsonFile(File file, Class<T> class_) {
        try {
            FileReader reader = new FileReader(file);
            return new Gson().fromJson((Reader)reader, class_);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public <T> T getTypeFromJsonFile(File file, Type class_) {
        try {
            FileReader reader = new FileReader(file);
            return new Gson().fromJson((Reader)reader, class_);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T getTypeFromJsonInputStream(InputStream inputStream, Type class_) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));){
            String line;
            StringBuilder jsonString = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                jsonString.append(line);
            }
            Object t = new Gson().fromJson(jsonString.toString(), class_);
            return t;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getClassFromJsonFile(File file) {
        try {
            FileReader reader = new FileReader(file);
            return new Gson().fromJson((Reader)reader, Object.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void saveHashMapToJson(File file, HashMap<String, Object> objects) throws IOException {
        this.saveJsonToFile(file, objects);
    }

    public HashMap<String, Object> getHashMapFromJsonFile(File file) {
        Type type = new TypeToken<HashMap<String, Object>>(){}.getType();
        if (this.getTypeFromJsonFile(file, type) == null) {
            return new HashMap<String, Object>();
        }
        return (HashMap)this.getTypeFromJsonFile(file, type);
    }

    public HashMap<String, Object> getHashMapFromJsonFile(InputStream inputStream) {
        Type type = new TypeToken<HashMap<String, Object>>(){}.getType();
        return (HashMap)this.getTypeFromJsonInputStream(inputStream, type);
    }
}

