/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.simplejsonutils;

import ch.framedev.simplejsonutils.Flag;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JsonParserCopy {
    private boolean indent;
    private boolean debug;

    public JsonParserCopy() {
        this.indent = false;
        this.debug = false;
    }

    public JsonParserCopy(Flag ... flags) {
        for (Flag f : flags) {
            if (f == Flag.USE_INDENT || f == Flag.PRETTY_PRINT) {
                this.indent = true;
            }
            if (f != Flag.DEBUG) continue;
            this.debug = true;
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public String serializeObject(Object object) {
        return this.serializeValue(object, 0);
    }

    private String serializeValue(Object value, int indentLevel) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            return "\"" + this.escapeJson(enumValue.name()) + "\"";
        }
        if (value instanceof Map) {
            return this.serializeMap((Map)value, indentLevel);
        }
        if (value instanceof List) {
            return this.serializeList((List)value, indentLevel);
        }
        if (this.isCustomClass(value.getClass())) {
            return this.serializeObjectFields(value, indentLevel);
        }
        if (value instanceof Double || value instanceof Float) {
            return new BigDecimal(value.toString()).toPlainString();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toPlainString();
        }
        if (value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof String) {
            return "\"" + this.escapeJson((String)value) + "\"";
        }
        throw new IllegalArgumentException("Unsupported data type: " + value.getClass().getSimpleName());
    }

    private String serializeList(List<?> list, int indentLevel) {
        StringBuilder sb = new StringBuilder("[");
        String indent = this.indent ? "\n" + "  ".repeat(indentLevel + 1) : "";
        for (Object item : list) {
            sb.append(indent).append(this.serializeValue(item, indentLevel + 1)).append(",");
        }
        if (!list.isEmpty()) {
            sb.setLength(sb.length() - 1);
        }
        return sb.append((String)(this.indent ? "\n" + "  ".repeat(indentLevel) + "]" : "]")).toString();
    }

    private String serializeMap(Map<?, ?> map, int indentLevel) {
        if (map.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("{");
        String indent = this.indent ? "\n" + "  ".repeat(indentLevel + 1) : "";
        int count = 0;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getKey() == null) {
                System.err.println("\u274c Warning: Null key detected. Skipping entry.");
                continue;
            }
            String key = this.escapeJson(entry.getKey().toString());
            Object value = entry.getValue();
            String serializedValue = this.serializeValue(value, indentLevel + 1);
            sb.append(indent).append("\"").append(key).append("\": ").append(serializedValue);
            if (++count >= map.size()) continue;
            sb.append(",");
        }
        return sb.append((String)(this.indent ? "\n" + "  ".repeat(indentLevel) + "}" : "}")).toString();
    }

    private String serializeObjectFields(Object obj, int indentLevel) {
        Field[] fields = obj.getClass().getDeclaredFields();
        if (fields.length == 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("{");
        String indent = this.indent ? "\n" + "  ".repeat(indentLevel + 1) : "";
        String closingIndent = this.indent ? "\n" + "  ".repeat(indentLevel) : "";
        boolean hasFields = false;
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                if (!field.trySetAccessible()) continue;
                Object fieldValue = field.get(obj);
                String serializedValue = this.serializeValue(fieldValue, indentLevel + 1);
                sb.append(indent).append("\"").append(this.escapeJson(field.getName())).append("\": ").append(fieldValue != null ? serializedValue : "null").append(",");
                hasFields = true;
            }
            catch (Exception e) {
                System.err.println("\u26a0\ufe0f Warning: Could not access field '" + field.getName() + "' in " + obj.getClass().getSimpleName());
            }
        }
        if (hasFields) {
            sb.setLength(sb.length() - 1);
        }
        return sb.append(closingIndent).append("}").toString();
    }

    public Object deserializeObject(String json, Class<?> clazz) {
        json = json.trim();
        if (!this.isCustomClass(clazz)) {
            return this.convertValue(clazz, json);
        }
        if (List.class.isAssignableFrom(clazz)) {
            return this.parseJsonList(this.parseJsonRawList(json), Object.class);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return this.parseJsonMap(json);
        }
        if (json.startsWith("{")) {
            return this.parseJsonObject(json, clazz);
        }
        throw new IllegalArgumentException("Invalid JSON format");
    }

    private <T> T parseJsonObject(String json, Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            T obj = constructor.newInstance(new Object[0]);
            Map<String, Object> map = this.parseJsonMap(json);
            try {
                for (Field field : clazz.getDeclaredFields()) {
                    field.setAccessible(true);
                    String fieldName = field.getName();
                    if (map.containsKey(fieldName)) {
                        Object value = map.get(fieldName);
                        if (Map.class.isAssignableFrom(field.getType()) && value instanceof Map) {
                            field.set(obj, value);
                        } else if (this.isCustomClass(field.getType()) && value instanceof Map) {
                            field.set(obj, this.parseJsonObjectMap((Map)value, field.getType()));
                        } else if (List.class.isAssignableFrom(field.getType()) && value instanceof List) {
                            Type genericType = field.getGenericType();
                            if (genericType instanceof ParameterizedType) {
                                Class listType = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                                field.set(obj, this.parseJsonList((List)value, listType));
                            }
                        } else {
                            field.set(obj, this.convertValue(field.getType(), value));
                        }
                        map.remove(fieldName);
                        continue;
                    }
                    System.out.println("\u26a0\ufe0f WARNING: No matching key found in JSON for field: " + fieldName);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return obj;
        }
        catch (Exception e) {
            throw new RuntimeException("Error deserializing JSON into " + clazz.getName(), e);
        }
    }

    private <T> T parseJsonObjectMap(Map<String, Object> map, Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            T obj = constructor.newInstance(new Object[0]);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String fieldName = entry.getKey();
                Object value = entry.getValue();
                try {
                    Field field = clazz.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    if (List.class.isAssignableFrom(field.getType())) {
                        Type genericType = field.getGenericType();
                        if (genericType instanceof ParameterizedType) {
                            Class listType = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                            value = this.parseJsonList((List)value, listType);
                        }
                    } else {
                        value = this.isCustomClass(field.getType()) && value instanceof Map ? this.parseJsonObjectMap((Map)value, field.getType()) : this.convertValue(field.getType(), value);
                    }
                    field.set(obj, value);
                }
                catch (NoSuchFieldException e) {
                    System.out.println("\u26a0\ufe0f WARNING: No field found for key: " + fieldName);
                }
            }
            return obj;
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing Map into " + clazz.getName(), e);
        }
    }

    private List<Object> parseJsonRawList(String json) {
        if (!(json = json.trim()).startsWith("[") || !json.endsWith("]")) {
            throw new IllegalArgumentException("Invalid JSON array format: " + json);
        }
        json = json.substring(1, json.length() - 1).trim();
        ArrayList<Object> list = new ArrayList<Object>();
        if (json.isEmpty()) {
            return list;
        }
        boolean insideString = false;
        StringBuilder item = new StringBuilder();
        for (char c : json.toCharArray()) {
            if (c == '\"') {
                boolean bl = insideString = !insideString;
            }
            if (c == ',' && !insideString) {
                list.add(this.parseJsonValue(item.toString().trim()));
                item.setLength(0);
                continue;
            }
            item.append(c);
        }
        if (item.length() > 0) {
            list.add(this.parseJsonValue(item.toString().trim()));
        }
        return list;
    }

    private <T> List<T> parseJsonList(List<?> jsonList, Class<T> listType) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object item : jsonList) {
            if (listType == null) {
                listType = String.class;
            }
            if (item == null) {
                list.add(null);
                continue;
            }
            if (String.class.isAssignableFrom(listType)) {
                list.add(item);
                continue;
            }
            if (this.isCustomClass(listType)) {
                list.add(this.parseJsonObject(item.toString(), listType));
                continue;
            }
            list.add(this.convertValue(listType, item));
        }
        return list;
    }

    private Map<String, Object> parseJsonMap(String json) {
        Object valueStr;
        String keyStr;
        json = json.trim();
        if (this.debug) {
            System.out.println("\ud83d\udd0d Processing JSON Map: " + json);
        }
        if (!json.startsWith("{") || !json.endsWith("}")) {
            throw new IllegalArgumentException("Invalid JSON object format: " + json);
        }
        json = json.substring(1, json.length() - 1).trim();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> deferredProcessing = new LinkedHashMap<String, Object>();
        if (json.isEmpty()) {
            return map;
        }
        boolean insideString = false;
        boolean insideObject = false;
        boolean insideList = false;
        int nestedLevel = 0;
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        boolean readingValue = false;
        boolean foundSeparator = false;
        for (int i = 0; i < json.length(); ++i) {
            char c = json.charAt(i);
            if (c == '\"' && (i == 0 || json.charAt(i - 1) != '\\')) {
                boolean bl = insideString = !insideString;
            }
            if (!insideString) {
                if (c == '{') {
                    insideObject = true;
                    ++nestedLevel;
                } else if (c == '}') {
                    if (--nestedLevel == 0) {
                        insideObject = false;
                    }
                } else if (c == '[') {
                    insideList = true;
                    ++nestedLevel;
                } else if (c == ']' && --nestedLevel == 0) {
                    insideList = false;
                }
            }
            if (!(c != ':' || insideString || insideObject || insideList)) {
                readingValue = true;
                foundSeparator = true;
                continue;
            }
            if (!(c != ',' && i != json.length() - 1 || insideString || nestedLevel != 0)) {
                if (foundSeparator) {
                    keyStr = key.toString().trim().replace("\"", "");
                    valueStr = value.toString().trim();
                    if (i == json.length() - 1 && c != ',') {
                        valueStr = (String)valueStr + c;
                    }
                    if (this.debug) {
                        System.out.println("\ud83d\udccc Key: " + keyStr + " | Value: " + (String)(((String)valueStr).isEmpty() ? "(missing)" : valueStr));
                    }
                    if (!keyStr.isEmpty()) {
                        if (((String)(valueStr = ((String)valueStr).trim())).startsWith("{") && ((String)valueStr).endsWith("}")) {
                            deferredProcessing.put(keyStr, valueStr);
                        } else if (((String)valueStr).startsWith("[") && ((String)valueStr).endsWith("]")) {
                            map.put(keyStr, this.parseJsonList(this.parseJsonRawList((String)valueStr), Object.class));
                        } else {
                            map.put(keyStr, this.parseJsonValue((String)valueStr));
                        }
                    }
                }
                if (!map.containsKey(keyStr = key.toString().replace("\"", "").trim()) && !deferredProcessing.containsKey(keyStr)) {
                    String[] pair = keyStr.split(":");
                    keyStr = pair[0];
                    valueStr = pair[1];
                    if (i == json.length() - 1 && c != ',') {
                        valueStr = (String)valueStr + c;
                    }
                    if (this.debug) {
                        System.out.println("Missing key added: " + keyStr + " Value: " + (String)valueStr);
                    }
                    if (((String)valueStr).startsWith("{")) {
                        deferredProcessing.put(keyStr, valueStr);
                    }
                    if (((String)valueStr).startsWith("[")) {
                        map.put(keyStr, this.parseJsonList(this.parseJsonRawList((String)valueStr), Object.class));
                    } else {
                        map.put(keyStr, this.parseJsonValue((String)valueStr));
                    }
                }
                key.setLength(0);
                value.setLength(0);
                readingValue = false;
                foundSeparator = false;
                continue;
            }
            if (readingValue) {
                value.append(c);
                continue;
            }
            key.append(c);
        }
        for (Map.Entry entry : deferredProcessing.entrySet()) {
            keyStr = (String)entry.getKey();
            valueStr = (String)entry.getValue();
            if (this.debug) {
                System.out.println("\u23f3 Processing deferred: " + keyStr + " \u2192 " + (String)valueStr);
            }
            if (((String)valueStr).startsWith("{")) {
                map.put(keyStr, this.parseJsonMap((String)valueStr));
                continue;
            }
            if (!((String)valueStr).startsWith("[")) continue;
            map.put(keyStr, this.parseJsonList(this.parseJsonRawList((String)valueStr), Object.class));
        }
        return map;
    }

    private Map<String, Object> cleanJsonStrings(Map<String, Object> map) {
        HashMap<String, Object> cleanedMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                String strValue = (String)value;
                if (strValue.contains("\"")) {
                    strValue = strValue.replace("\"", "");
                }
                cleanedMap.put(entry.getKey(), strValue);
                continue;
            }
            cleanedMap.put(entry.getKey(), value);
        }
        return cleanedMap;
    }

    private int findMatchingBrace(String json, int startIndex) {
        int openBraces = 1;
        for (int i = startIndex + 1; i < json.length(); ++i) {
            char c = json.charAt(i);
            if (c == '{') {
                ++openBraces;
            }
            if (c != '}' || --openBraces != 0) continue;
            return i;
        }
        return -1;
    }

    private Object convertValue(Class<?> type, Object value) {
        if (value == null) {
            return null;
        }
        String strValueTrimmed = this.escapeJson(value.toString().replaceAll("^\"|\"$", "").replace("\\", "").trim());
        String strValue = value.toString().replace("\"", "").trim();
        if (type == String.class) {
            return strValueTrimmed;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.parseBoolean(strValue);
        }
        if (!strValue.contains(".")) {
            if ((type == Integer.TYPE || type == Integer.class) && strValue.matches("-?\\d+")) {
                return Integer.parseInt(strValue);
            }
            if ((type == Long.TYPE || type == Long.class) && strValue.matches("-?\\d+")) {
                return Long.parseLong(strValue);
            }
        } else if (type == Double.TYPE || type == Double.class) {
            return new BigDecimal(strValue).doubleValue();
        }
        if (type.isEnum()) {
            return Enum.valueOf(type, strValue);
        }
        return value;
    }

    private Object parseJsonValue(String value) {
        if ((value = value.trim()).equals("null")) {
            return null;
        }
        if (value.startsWith("{") && value.endsWith("}")) {
            return this.parseJsonMap(value);
        }
        if (value.startsWith("[") && value.endsWith("]")) {
            return this.parseJsonList(this.parseJsonRawList(value), Object.class);
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return this.escapeJson(value.substring(1, value.length() - 1).replace("\"", "").replace("\\", ""));
        }
        if (value.equals("true") || value.equals("false")) {
            return Boolean.parseBoolean(value);
        }
        if (value.matches("-?\\d+\\.\\d+")) {
            return Double.parseDouble(value);
        }
        if (value.matches("-?\\d+")) {
            return Integer.parseInt(value);
        }
        return value;
    }

    private String escapeJson(String str) {
        return str.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t").replaceAll("\\\\+$", "");
    }

    private boolean isCustomClass(Class<?> clazz) {
        return !clazz.isPrimitive() && !clazz.equals(String.class) && !clazz.isAssignableFrom(String.class) && !Number.class.isAssignableFrom(clazz) && !clazz.equals(Boolean.class);
    }

    public void saveToFile(File file, Object object) throws Exception {
        String json = this.serializeObject(object);
        try (FileWriter writer = new FileWriter(file);){
            writer.write(json);
        }
    }

    public Object loadFromFile(File file, Class<?> clazz) throws Exception {
        if (!file.exists()) {
            return null;
        }
        StringBuilder jsonBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                jsonBuilder.append(line);
            }
        }
        return this.deserializeObject(jsonBuilder.toString(), clazz);
    }
}

