/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.MongoClientException;
import com.mongodb.MongoConfigurationException;
import com.mongodb.ReadPreference;
import com.mongodb.ReadPreferenceHedgeOptions;
import com.mongodb.Tag;
import com.mongodb.TagSet;
import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.connection.ClusterDescriptionHelper;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonString;

@Immutable
public abstract class TaggableReadPreference
extends ReadPreference {
    private static final int SMALLEST_MAX_STALENESS_MS = 90000;
    private static final int IDLE_WRITE_PERIOD_MS = 10000;
    private final List<TagSet> tagSetList = new ArrayList<TagSet>();
    private final Long maxStalenessMS;
    private final ReadPreferenceHedgeOptions hedgeOptions;

    TaggableReadPreference() {
        this.maxStalenessMS = null;
        this.hedgeOptions = null;
    }

    TaggableReadPreference(List<TagSet> tagSetList, @Nullable Long maxStaleness, TimeUnit timeUnit, @Nullable ReadPreferenceHedgeOptions hedgeOptions) {
        Assertions.notNull("tagSetList", tagSetList);
        Assertions.isTrueArgument("maxStaleness is null or >= 0", maxStaleness == null || maxStaleness >= 0L);
        this.maxStalenessMS = maxStaleness == null ? null : Long.valueOf(TimeUnit.MILLISECONDS.convert(maxStaleness, timeUnit));
        this.tagSetList.addAll(tagSetList);
        this.hedgeOptions = hedgeOptions;
    }

    @Override
    public abstract TaggableReadPreference withTagSet(TagSet var1);

    @Override
    public abstract TaggableReadPreference withTagSetList(List<TagSet> var1);

    @Override
    public abstract TaggableReadPreference withMaxStalenessMS(Long var1, TimeUnit var2);

    @Override
    public abstract TaggableReadPreference withHedgeOptions(ReadPreferenceHedgeOptions var1);

    @Override
    public boolean isSecondaryOk() {
        return true;
    }

    @Override
    public BsonDocument toDocument() {
        BsonDocument readPrefObject = new BsonDocument("mode", new BsonString(this.getName()));
        if (!this.tagSetList.isEmpty()) {
            readPrefObject.put("tags", this.tagsListToBsonArray());
        }
        if (this.maxStalenessMS != null) {
            readPrefObject.put("maxStalenessSeconds", new BsonInt64(TimeUnit.MILLISECONDS.toSeconds(this.maxStalenessMS)));
        }
        if (this.hedgeOptions != null) {
            readPrefObject.put("hedge", this.hedgeOptions.toBsonDocument());
        }
        return readPrefObject;
    }

    public List<TagSet> getTagSetList() {
        return Collections.unmodifiableList(this.tagSetList);
    }

    @Nullable
    public Long getMaxStaleness(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        if (this.maxStalenessMS == null) {
            return null;
        }
        return timeUnit.convert(this.maxStalenessMS, TimeUnit.MILLISECONDS);
    }

    @Nullable
    public ReadPreferenceHedgeOptions getHedgeOptions() {
        return this.hedgeOptions;
    }

    public String toString() {
        return "ReadPreference{name=" + this.getName() + (this.tagSetList.isEmpty() ? "" : ", tagSetList=" + this.tagSetList) + (this.maxStalenessMS == null ? "" : ", maxStalenessMS=" + this.maxStalenessMS) + ", hedgeOptions=" + this.hedgeOptions + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaggableReadPreference that = (TaggableReadPreference)o;
        if (!Objects.equals(this.maxStalenessMS, that.maxStalenessMS)) {
            return false;
        }
        if (!this.tagSetList.equals(that.tagSetList)) {
            return false;
        }
        return Objects.equals(this.hedgeOptions, that.hedgeOptions);
    }

    public int hashCode() {
        int result = this.tagSetList.hashCode();
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + (this.maxStalenessMS != null ? this.maxStalenessMS.hashCode() : 0);
        result = 31 * result + (this.hedgeOptions != null ? this.hedgeOptions.hashCode() : 0);
        return result;
    }

    @Override
    protected List<ServerDescription> chooseForNonReplicaSet(ClusterDescription clusterDescription) {
        return this.selectFreshServers(clusterDescription, ClusterDescriptionHelper.getAny(clusterDescription));
    }

    static ClusterDescription copyClusterDescription(ClusterDescription clusterDescription, List<ServerDescription> selectedServers) {
        return new ClusterDescription(clusterDescription.getConnectionMode(), clusterDescription.getType(), selectedServers, clusterDescription.getClusterSettings(), clusterDescription.getServerSettings());
    }

    List<ServerDescription> selectFreshServers(ClusterDescription clusterDescription, List<ServerDescription> servers) {
        ArrayList<ServerDescription> freshServers;
        block10: {
            long heartbeatFrequencyMS;
            Long maxStaleness;
            block9: {
                maxStaleness = this.getMaxStaleness(TimeUnit.MILLISECONDS);
                if (maxStaleness == null) {
                    return servers;
                }
                if (clusterDescription.getServerSettings() == null) {
                    throw new MongoConfigurationException("heartbeat frequency must be provided in cluster description");
                }
                if (!this.serversAreAllThreeDotFour(clusterDescription)) {
                    throw new MongoConfigurationException("Servers must all be at least version 3.4 when max staleness is configured");
                }
                if (clusterDescription.getType() != ClusterType.REPLICA_SET) {
                    return servers;
                }
                heartbeatFrequencyMS = clusterDescription.getServerSettings().getHeartbeatFrequency(TimeUnit.MILLISECONDS);
                if (maxStaleness < Math.max(90000L, heartbeatFrequencyMS + 10000L)) {
                    if (90000L > heartbeatFrequencyMS + 10000L) {
                        throw new MongoConfigurationException(String.format("Max staleness (%d sec) must be at least 90 seconds", this.getMaxStaleness(TimeUnit.SECONDS)));
                    }
                    throw new MongoConfigurationException(String.format("Max staleness (%d ms) must be at least the heartbeat period (%d ms) plus the idle write period (%d ms)", maxStaleness, heartbeatFrequencyMS, 10000));
                }
                freshServers = new ArrayList<ServerDescription>(servers.size());
                ServerDescription primary = this.findPrimary(clusterDescription);
                if (primary == null) break block9;
                for (ServerDescription cur : servers) {
                    if (cur.isPrimary()) {
                        freshServers.add(cur);
                        continue;
                    }
                    if (this.getStalenessOfSecondaryRelativeToPrimary(primary, cur, heartbeatFrequencyMS) > maxStaleness) continue;
                    freshServers.add(cur);
                }
                break block10;
            }
            ServerDescription mostUpToDateSecondary = this.findMostUpToDateSecondary(clusterDescription);
            if (mostUpToDateSecondary == null) break block10;
            for (ServerDescription cur : servers) {
                if (this.getLastWriteDateNonNull(mostUpToDateSecondary).getTime() - this.getLastWriteDateNonNull(cur).getTime() + heartbeatFrequencyMS > maxStaleness) continue;
                freshServers.add(cur);
            }
        }
        return freshServers;
    }

    private long getStalenessOfSecondaryRelativeToPrimary(ServerDescription primary, ServerDescription serverDescription, long heartbeatFrequencyMS) {
        return this.getLastWriteDateNonNull(primary).getTime() + (serverDescription.getLastUpdateTime(TimeUnit.MILLISECONDS) - primary.getLastUpdateTime(TimeUnit.MILLISECONDS)) - this.getLastWriteDateNonNull(serverDescription).getTime() + heartbeatFrequencyMS;
    }

    @Nullable
    private ServerDescription findPrimary(ClusterDescription clusterDescription) {
        for (ServerDescription cur : clusterDescription.getServerDescriptions()) {
            if (!cur.isPrimary()) continue;
            return cur;
        }
        return null;
    }

    private ServerDescription findMostUpToDateSecondary(ClusterDescription clusterDescription) {
        ServerDescription mostUpdateToDateSecondary = null;
        for (ServerDescription cur : clusterDescription.getServerDescriptions()) {
            if (!cur.isSecondary() || mostUpdateToDateSecondary != null && this.getLastWriteDateNonNull(cur).getTime() <= this.getLastWriteDateNonNull(mostUpdateToDateSecondary).getTime()) continue;
            mostUpdateToDateSecondary = cur;
        }
        return mostUpdateToDateSecondary;
    }

    private Date getLastWriteDateNonNull(ServerDescription serverDescription) {
        Date lastWriteDate = serverDescription.getLastWriteDate();
        if (lastWriteDate == null) {
            throw new MongoClientException("lastWriteDate should not be null in " + serverDescription);
        }
        return lastWriteDate;
    }

    private boolean serversAreAllThreeDotFour(ClusterDescription clusterDescription) {
        for (ServerDescription cur : clusterDescription.getServerDescriptions()) {
            if (!cur.isOk() || cur.getMaxWireVersion() >= 5) continue;
            return false;
        }
        return true;
    }

    private BsonArray tagsListToBsonArray() {
        BsonArray bsonArray = new BsonArray(this.tagSetList.size());
        for (TagSet tagSet : this.tagSetList) {
            bsonArray.add(this.toDocument(tagSet));
        }
        return bsonArray;
    }

    private BsonDocument toDocument(TagSet tagSet) {
        BsonDocument document = new BsonDocument();
        for (Tag tag : tagSet) {
            document.put(tag.getName(), new BsonString(tag.getValue()));
        }
        return document;
    }

    static class PrimaryPreferredReadPreference
    extends SecondaryReadPreference {
        PrimaryPreferredReadPreference() {
        }

        PrimaryPreferredReadPreference(List<TagSet> tagSetList, @Nullable Long maxStaleness, TimeUnit timeUnit) {
            this(tagSetList, maxStaleness, timeUnit, null);
        }

        PrimaryPreferredReadPreference(List<TagSet> tagSetList, @Nullable Long maxStaleness, TimeUnit timeUnit, @Nullable ReadPreferenceHedgeOptions hedgeOptions) {
            super(tagSetList, maxStaleness, timeUnit, hedgeOptions);
        }

        @Override
        public TaggableReadPreference withTagSet(TagSet tagSet) {
            return this.withTagSetList((List)Collections.singletonList(tagSet));
        }

        @Override
        public TaggableReadPreference withTagSetList(List<TagSet> tagSetList) {
            Assertions.notNull("tagSetList", tagSetList);
            return new PrimaryPreferredReadPreference(tagSetList, this.getMaxStaleness(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, this.getHedgeOptions());
        }

        @Override
        public TaggableReadPreference withMaxStalenessMS(@Nullable Long maxStaleness, TimeUnit timeUnit) {
            Assertions.isTrueArgument("maxStaleness is null or >= 0", maxStaleness == null || maxStaleness >= 0L);
            return new PrimaryPreferredReadPreference(this.getTagSetList(), maxStaleness, timeUnit, this.getHedgeOptions());
        }

        @Override
        public TaggableReadPreference withHedgeOptions(ReadPreferenceHedgeOptions hedgeOptions) {
            return new PrimaryPreferredReadPreference(this.getTagSetList(), this.getMaxStaleness(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, hedgeOptions);
        }

        @Override
        public String getName() {
            return "primaryPreferred";
        }

        @Override
        protected List<ServerDescription> chooseForReplicaSet(ClusterDescription clusterDescription) {
            List<ServerDescription> selectedServers = this.selectFreshServers(clusterDescription, ClusterDescriptionHelper.getPrimaries(clusterDescription));
            if (selectedServers.isEmpty()) {
                selectedServers = super.chooseForReplicaSet(clusterDescription);
            }
            return selectedServers;
        }
    }

    static class NearestReadPreference
    extends TaggableReadPreference {
        NearestReadPreference() {
        }

        NearestReadPreference(List<TagSet> tagSetList, @Nullable Long maxStaleness, TimeUnit timeUnit) {
            this(tagSetList, maxStaleness, timeUnit, null);
        }

        NearestReadPreference(List<TagSet> tagSetList, @Nullable Long maxStaleness, TimeUnit timeUnit, @Nullable ReadPreferenceHedgeOptions hedgeOptions) {
            super(tagSetList, maxStaleness, timeUnit, hedgeOptions);
        }

        @Override
        public TaggableReadPreference withTagSet(TagSet tagSet) {
            return this.withTagSetList((List)Collections.singletonList(tagSet));
        }

        @Override
        public TaggableReadPreference withTagSetList(List<TagSet> tagSetList) {
            Assertions.notNull("tagSetList", tagSetList);
            return new NearestReadPreference(tagSetList, this.getMaxStaleness(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, this.getHedgeOptions());
        }

        @Override
        public TaggableReadPreference withMaxStalenessMS(@Nullable Long maxStaleness, TimeUnit timeUnit) {
            Assertions.isTrueArgument("maxStaleness is null or >= 0", maxStaleness == null || maxStaleness >= 0L);
            return new NearestReadPreference(this.getTagSetList(), maxStaleness, timeUnit, this.getHedgeOptions());
        }

        @Override
        public TaggableReadPreference withHedgeOptions(ReadPreferenceHedgeOptions hedgeOptions) {
            return new NearestReadPreference(this.getTagSetList(), this.getMaxStaleness(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, hedgeOptions);
        }

        @Override
        public String getName() {
            return "nearest";
        }

        @Override
        public List<ServerDescription> chooseForReplicaSet(ClusterDescription clusterDescription) {
            List<ServerDescription> selectedServers = this.selectFreshServers(clusterDescription, ClusterDescriptionHelper.getAnyPrimaryOrSecondary(clusterDescription));
            if (!this.getTagSetList().isEmpty()) {
                ClusterDescription nonStaleClusterDescription = NearestReadPreference.copyClusterDescription(clusterDescription, selectedServers);
                selectedServers = Collections.emptyList();
                for (TagSet tagSet : this.getTagSetList()) {
                    List<ServerDescription> servers = ClusterDescriptionHelper.getAnyPrimaryOrSecondary(nonStaleClusterDescription, tagSet);
                    if (servers.isEmpty()) continue;
                    selectedServers = servers;
                    break;
                }
            }
            return selectedServers;
        }
    }

    static class SecondaryPreferredReadPreference
    extends SecondaryReadPreference {
        SecondaryPreferredReadPreference() {
        }

        SecondaryPreferredReadPreference(List<TagSet> tagSetList, @Nullable Long maxStaleness, TimeUnit timeUnit) {
            this(tagSetList, maxStaleness, timeUnit, null);
        }

        SecondaryPreferredReadPreference(List<TagSet> tagSetList, @Nullable Long maxStaleness, TimeUnit timeUnit, @Nullable ReadPreferenceHedgeOptions hedgeOptions) {
            super(tagSetList, maxStaleness, timeUnit, hedgeOptions);
        }

        @Override
        public TaggableReadPreference withTagSet(TagSet tagSet) {
            return this.withTagSetList((List)Collections.singletonList(tagSet));
        }

        @Override
        public TaggableReadPreference withTagSetList(List<TagSet> tagSetList) {
            Assertions.notNull("tagSetList", tagSetList);
            return new SecondaryPreferredReadPreference(tagSetList, this.getMaxStaleness(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, this.getHedgeOptions());
        }

        @Override
        public TaggableReadPreference withMaxStalenessMS(@Nullable Long maxStaleness, TimeUnit timeUnit) {
            Assertions.isTrueArgument("maxStaleness is null or >= 0", maxStaleness == null || maxStaleness >= 0L);
            return new SecondaryPreferredReadPreference(this.getTagSetList(), maxStaleness, timeUnit, this.getHedgeOptions());
        }

        @Override
        public TaggableReadPreference withHedgeOptions(ReadPreferenceHedgeOptions hedgeOptions) {
            return new SecondaryPreferredReadPreference(this.getTagSetList(), this.getMaxStaleness(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, hedgeOptions);
        }

        @Override
        public String getName() {
            return "secondaryPreferred";
        }

        @Override
        protected List<ServerDescription> chooseForReplicaSet(ClusterDescription clusterDescription) {
            List<ServerDescription> selectedServers = super.chooseForReplicaSet(clusterDescription);
            if (selectedServers.isEmpty()) {
                selectedServers = ClusterDescriptionHelper.getPrimaries(clusterDescription);
            }
            return selectedServers;
        }
    }

    static class SecondaryReadPreference
    extends TaggableReadPreference {
        SecondaryReadPreference() {
        }

        SecondaryReadPreference(List<TagSet> tagSetList, @Nullable Long maxStaleness, TimeUnit timeUnit) {
            this(tagSetList, maxStaleness, timeUnit, null);
        }

        SecondaryReadPreference(List<TagSet> tagSetList, @Nullable Long maxStaleness, TimeUnit timeUnit, @Nullable ReadPreferenceHedgeOptions hedgeOptions) {
            super(tagSetList, maxStaleness, timeUnit, hedgeOptions);
        }

        @Override
        public TaggableReadPreference withTagSet(TagSet tagSet) {
            return this.withTagSetList((List)Collections.singletonList(tagSet));
        }

        @Override
        public TaggableReadPreference withTagSetList(List<TagSet> tagSetList) {
            Assertions.notNull("tagSetList", tagSetList);
            return new SecondaryReadPreference(tagSetList, this.getMaxStaleness(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, this.getHedgeOptions());
        }

        @Override
        public TaggableReadPreference withMaxStalenessMS(@Nullable Long maxStaleness, TimeUnit timeUnit) {
            Assertions.isTrueArgument("maxStaleness is null or >= 0", maxStaleness == null || maxStaleness >= 0L);
            return new SecondaryReadPreference(this.getTagSetList(), maxStaleness, timeUnit, this.getHedgeOptions());
        }

        @Override
        public TaggableReadPreference withHedgeOptions(ReadPreferenceHedgeOptions hedgeOptions) {
            return new SecondaryReadPreference(this.getTagSetList(), this.getMaxStaleness(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, hedgeOptions);
        }

        @Override
        public String getName() {
            return "secondary";
        }

        @Override
        protected List<ServerDescription> chooseForReplicaSet(ClusterDescription clusterDescription) {
            List<ServerDescription> selectedServers = this.selectFreshServers(clusterDescription, ClusterDescriptionHelper.getSecondaries(clusterDescription));
            if (!this.getTagSetList().isEmpty()) {
                ClusterDescription nonStaleClusterDescription = SecondaryReadPreference.copyClusterDescription(clusterDescription, selectedServers);
                selectedServers = Collections.emptyList();
                for (TagSet tagSet : this.getTagSetList()) {
                    List<ServerDescription> servers = ClusterDescriptionHelper.getSecondaries(nonStaleClusterDescription, tagSet);
                    if (servers.isEmpty()) continue;
                    selectedServers = servers;
                    break;
                }
            }
            return selectedServers;
        }
    }
}

