/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.javamysqlutils;

import ch.framedev.javamysqlutils.JsonConnection;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class MySQLV2 {
    private String host;
    private String user;
    private String password;
    private String database;
    private String port;
    private JsonConnection jsonConnection;
    private Connection connection;
    private boolean allowPublicKey;
    private HikariDataSource ds;
    private final ExecutorService executor = Executors.newFixedThreadPool(10);

    public void setJsonConnection(JsonConnection jsonConnection) {
        this.jsonConnection = jsonConnection;
    }

    public JsonConnection getJsonConnection() {
        return this.jsonConnection;
    }

    public MySQLV2(JsonConnection jsonConnection) {
        this.jsonConnection = jsonConnection;
        this.host = jsonConnection.getHost();
        this.user = jsonConnection.getUser();
        this.password = jsonConnection.getPassword();
        this.database = jsonConnection.getDatabase();
        this.port = String.valueOf(jsonConnection.getPort());
    }

    public MySQLV2(String host, String user, String password, int port, String database) {
        this.host = host;
        this.user = user;
        this.password = password;
        this.port = String.valueOf(port);
        this.database = database;
    }

    public void setAllowPublicKey(boolean allowPublicKey) {
        this.allowPublicKey = allowPublicKey;
    }

    public boolean isAllowPublicKey() {
        return this.allowPublicKey;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void connect() {
        if (this.ds == null) {
            try {
                Class.forName("com.mysql.cj.jdbc.Driver");
                System.out.println("Driver loaded manually.");
            }
            catch (ClassNotFoundException e) {
                try {
                    Class.forName("com.mysql.jdbc.Driver");
                    System.out.println("Driver loaded manually.");
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
            }
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database);
            config.setUsername(this.user);
            config.setPassword(this.password);
            config.addDataSourceProperty("cachePrepStmts", "true");
            config.addDataSourceProperty("prepStmtCacheSize", "250");
            config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
            config.addDataSourceProperty("useServerPrepStmts", "true");
            config.addDataSourceProperty("useSSL", "false");
            config.addDataSourceProperty("serverTimezone", "UTC");
            config.addDataSourceProperty("allowPublicKeyRetrieval", "true");
            this.ds = new HikariDataSource(config);
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.ds == null) {
            this.connect();
        }
        return this.ds.getConnection();
    }

    public void close() {
        if (this.ds != null && !this.ds.isClosed()) {
            this.ds.close();
        }
    }

    /*
     * Exception decompiling
     */
    public boolean isTableExists(String table) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void isTableExistsAsync(String table, Callback<Boolean> callback) {
        this.executor.execute(() -> {
            String sql = "SHOW TABLES LIKE ?";
            try (Connection conn = this.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, table);
                try (ResultSet rs = stmt.executeQuery();){
                    callback.onResult(rs.next());
                }
            }
            catch (SQLException ex) {
                callback.onError(ex);
            }
        });
    }

    public boolean createTable(String tableName, String ... columns) {
        boolean bl;
        block8: {
            this.throwErrorOnLength(columns == null || columns.length == 0, "At least one column must be specified.");
            String columnDefinitions = this.getColumnDefinitions(columns);
            String sql = "CREATE TABLE IF NOT EXISTS " + tableName + " (ID INT PRIMARY KEY AUTO_INCREMENT, " + columnDefinitions + ", created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP);";
            PreparedStatement stmt = this.getConnection().prepareStatement(sql);
            try {
                boolean bl2 = bl = stmt.executeUpdate() > 0;
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            stmt.close();
        }
        return bl;
    }

    public void createTableAsync(String tableName, final Callback<Boolean> callback, String ... columns) {
        this.throwErrorOnLength(columns == null || columns.length == 0, "At least one column must be specified.");
        String columnDefinitions = this.getColumnDefinitions(columns);
        final String sql = "CREATE TABLE IF NOT EXISTS " + tableName + " (ID INT PRIMARY KEY AUTO_INCREMENT, " + columnDefinitions + ", created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP);";
        this.executor.execute(new Runnable(){
            final /* synthetic */ MySQLV2 this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try (PreparedStatement stmt = this.this$0.getConnection().prepareStatement(sql);){
                    stmt.execute();
                    callback.onResult(true);
                }
                catch (SQLException e) {
                    callback.onError(e);
                }
            }
        });
    }

    private String getColumnDefinitions(String[] columns) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            stringBuilder.append(columns[i]);
            if (i >= columns.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean insertData(String table, Object[] data, String[] columns) {
        this.throwErrorOnLength(columns == null || columns.length == 0 || data == null || data.length == 0, "Columns and data must be provided.");
        this.throwErrorOnLength(columns.length != data.length, "Number of columns and data values must match.");
        String sql = this.createInsertSQL(table, columns);
        try (Connection conn = this.getConnection();){
            boolean bl;
            block15: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    for (int i = 0; i < data.length; ++i) {
                        stmt.setObject(i + 1, data[i]);
                    }
                    boolean bl2 = bl = stmt.executeUpdate() > 0;
                    if (stmt == null) break block15;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void insertDataAsync(String table, Object[] data, String[] columns, Callback<Boolean> callback) {
        this.throwErrorOnLength(columns == null || columns.length == 0 || data == null || data.length == 0, "Columns and data must be provided.");
        this.throwErrorOnLength(columns.length != data.length, "Number of columns and data values must match.");
        String sql = this.createInsertSQL(table, columns);
        this.executor.execute(() -> {
            try (Connection conn = this.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                for (int i = 0; i < data.length; ++i) {
                    stmt.setObject(i + 1, data[i]);
                }
                callback.onResult(stmt.executeUpdate() > 0);
            }
            catch (SQLException e) {
                callback.onError(e);
            }
        });
    }

    private String createInsertSQL(String table, String[] columns) {
        StringBuilder columnsBuilder = new StringBuilder();
        StringBuilder placeholdersBuilder = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            columnsBuilder.append(columns[i]);
            placeholdersBuilder.append("?");
            if (i >= columns.length - 1) continue;
            columnsBuilder.append(", ");
            placeholdersBuilder.append(", ");
        }
        return "INSERT INTO " + table + " (" + columnsBuilder + ") VALUES (" + placeholdersBuilder + ")";
    }

    private void throwErrorOnLength(boolean length, String s) {
        if (length) {
            throw new IllegalArgumentException(s);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean updateData(String table, String column, Object value, String whereClause) {
        String sql = "UPDATE " + table + " SET " + column + " = ? WHERE " + whereClause;
        try (Connection conn = this.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setObject(1, value);
                    int result = stmt.executeUpdate();
                    boolean bl2 = bl = result > 0;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void updateDataAsync(String table, String column, Object value, String whereClause, Callback<Boolean> callback) {
        String sql = "UPDATE " + table + " SET " + column + " = ? WHERE " + whereClause;
        this.executor.execute(() -> {
            try (Connection conn = this.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setObject(1, value);
                int result = stmt.executeUpdate();
                callback.onResult(result > 0);
            }
            catch (SQLException e) {
                callback.onError(e);
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean updateData(String table, String[] columns, Object[] values, String where) {
        if (columns.length == 0 || values.length == 0 || columns.length != values.length) {
            throw new IllegalArgumentException("Columns and values arrays must not be empty and must have the same length.");
        }
        StringBuilder setClause = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            setClause.append(columns[i]).append(" = ?");
            if (i >= columns.length - 1) continue;
            setClause.append(", ");
        }
        String sql = "UPDATE " + table + " SET " + setClause.toString() + " WHERE " + where;
        try (Connection conn = this.getConnection();){
            boolean bl;
            block17: {
                PreparedStatement pstmt = Objects.requireNonNull(conn).prepareStatement(sql);
                try {
                    for (int i = 0; i < values.length; ++i) {
                        pstmt.setObject(i + 1, values[i]);
                    }
                    boolean bl2 = bl = pstmt.executeUpdate() > 0;
                    if (pstmt == null) break block17;
                }
                catch (Throwable throwable) {
                    if (pstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                pstmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void updateDataAsync(String table, String[] columns, Object[] values, String where, Callback<Boolean> callback) {
        if (columns.length == 0 || values.length == 0 || columns.length != values.length) {
            throw new IllegalArgumentException("Columns and values arrays must not be empty and must have the same length.");
        }
        StringBuilder setClause = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            setClause.append(columns[i]).append(" = ?");
            if (i >= columns.length - 1) continue;
            setClause.append(", ");
        }
        String sql = "UPDATE " + table + " SET " + setClause.toString() + " WHERE " + where;
        this.executor.execute(() -> {
            try (Connection conn = this.getConnection();
                 PreparedStatement pstmt = Objects.requireNonNull(conn).prepareStatement(sql);){
                for (int i = 0; i < values.length; ++i) {
                    pstmt.setObject(i + 1, values[i]);
                }
                callback.onResult(pstmt.executeUpdate() > 0);
            }
            catch (SQLException e) {
                callback.onError(e);
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean deleteDataInTable(String table, String whereClause) {
        String sql = "DELETE FROM " + table + " WHERE " + whereClause;
        try (Connection conn = this.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    int result = stmt.executeUpdate();
                    boolean bl2 = bl = result > 0;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void deleteDataInTableAsync(String table, String whereClause, Callback<Boolean> callback) {
        String sql = "DELETE FROM " + table + " WHERE " + whereClause;
        this.executor.execute(() -> {
            try (Connection conn = this.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                int result = stmt.executeUpdate();
                callback.onResult(result > 0);
            }
            catch (SQLException e) {
                callback.onError(e);
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean deleteDataInTable(String table, String whereColumn, String whereValue, String andColumn, String andValue) {
        String sql = "DELETE FROM " + table + " WHERE " + whereColumn + " = ? AND " + andColumn + " = ?";
        try (Connection conn = this.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setString(1, whereValue);
                    stmt.setString(2, andValue);
                    int result = stmt.executeUpdate();
                    boolean bl2 = bl = result > 0;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void deleteDataInTableAsync(String table, String whereColumn, String whereValue, String andColumn, String andValue, Callback<Boolean> callback) {
        String sql = "DELETE FROM " + table + " WHERE " + whereColumn + " = ? AND " + andColumn + " = ?";
        this.executor.execute(() -> {
            try (Connection conn = this.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, whereValue);
                stmt.setString(2, andValue);
                int result = stmt.executeUpdate();
                callback.onResult(result > 0);
            }
            catch (SQLException e) {
                callback.onError(e);
            }
        });
    }

    /*
     * Exception decompiling
     */
    public boolean exists(String table, String column, String data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void existsAsync(String table, String column, String data, Callback<Boolean> callback) {
        String sql = "SELECT * FROM " + table + " WHERE " + column + " = ?";
        this.executor.execute(() -> {
            try (Connection conn = this.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, data);
                try (ResultSet res = stmt.executeQuery();){
                    callback.onResult(res.next());
                }
            }
            catch (SQLException e) {
                callback.onError(e);
            }
        });
    }

    /*
     * Exception decompiling
     */
    public boolean exists(String table, String column, String data, String andCondition) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void existsAsync(String table, String column, String data, String andCondition, Callback<Boolean> callback) {
        String sql = "SELECT * FROM " + table + " WHERE " + column + " = ? AND " + andCondition;
        this.executor.execute(() -> {
            try (Connection conn = this.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, data);
                try (ResultSet res = stmt.executeQuery();){
                    callback.onResult(res.next());
                }
            }
            catch (SQLException e) {
                callback.onError(e);
            }
        });
    }

    public void getAsync(String table, String selected, String column, String data, Callback<Object> callback) {
        String sql = "SELECT " + selected + " FROM " + table + " WHERE " + column + " = ?";
        this.executor.execute(() -> {
            try (Connection conn = this.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, data);
                try (ResultSet res = stmt.executeQuery();){
                    if (res.next()) {
                        callback.onResult(res.getObject(selected));
                    }
                }
            }
            catch (SQLException e) {
                callback.onError(e);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(String table, String selected, String column, String data) {
        String sql = "SELECT " + selected + " FROM " + table + " WHERE " + column + " = ?";
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, data);
            try (ResultSet res = stmt.executeQuery();){
                if (!res.next()) return null;
                Object object = res.getObject(selected);
                return object;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<Object> get(String table, String[] selectedColumns, String column, Object data, String andColumn, Object andValue) {
        String columns = String.join((CharSequence)", ", selectedColumns);
        String sql = "SELECT " + columns + " FROM " + table + " WHERE " + column + " = ? AND " + andColumn + " = ?";
        ArrayList<Object> results = new ArrayList<Object>();
        try (Connection conn = this.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setObject(1, data);
            pstmt.setObject(2, andValue);
            try (ResultSet res = pstmt.executeQuery();){
                while (res.next()) {
                    Object row = null;
                    for (String selectedColumn : selectedColumns) {
                        row = res.getObject(selectedColumn);
                        results.add(row);
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return results;
    }

    public void getAsync(String table, String[] selectedColumns, String column, Object data, String andColumn, Object andValue, Callback<List<Object>> callback) {
        String columns = String.join((CharSequence)", ", selectedColumns);
        String sql = "SELECT " + columns + " FROM " + table + " WHERE " + column + " = ? AND " + andColumn + " = ?";
        ArrayList results = new ArrayList();
        this.executor.execute(() -> {
            try (Connection conn = this.getConnection();
                 PreparedStatement pstmt = conn.prepareStatement(sql);){
                pstmt.setObject(1, data);
                pstmt.setObject(2, andValue);
                try (ResultSet res = pstmt.executeQuery();){
                    while (res.next()) {
                        Object row = null;
                        for (String selectedColumn : selectedColumns) {
                            row = res.getObject(selectedColumn);
                            results.add(row);
                        }
                    }
                    callback.onResult(results);
                }
            }
            catch (SQLException e) {
                callback.onError(e);
            }
        });
    }

    public List<Object> get(String table, String[] selectedColumns, String column, Object data) {
        String columns = String.join((CharSequence)", ", selectedColumns);
        String sql = "SELECT " + columns + " FROM " + table + " WHERE " + column + " = ?";
        ArrayList<Object> results = new ArrayList<Object>();
        try (Connection conn = this.getConnection();
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setObject(1, data);
            try (ResultSet res = pstmt.executeQuery();){
                while (res.next()) {
                    Object row = null;
                    for (String selectedColumn : selectedColumns) {
                        row = res.getObject(selectedColumn);
                        results.add(row);
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return results;
    }

    public void getAsync(String table, String[] selectedColumns, String column, Object data, Callback<List<Object>> callback) {
        String columns = String.join((CharSequence)", ", selectedColumns);
        String sql = "SELECT " + columns + " FROM " + table + " WHERE " + column + " = ?";
        ArrayList results = new ArrayList();
        this.executor.execute(() -> {
            try (Connection conn = this.getConnection();
                 PreparedStatement pstmt = conn.prepareStatement(sql);){
                pstmt.setObject(1, data);
                try (ResultSet res = pstmt.executeQuery();){
                    while (res.next()) {
                        Object row = null;
                        for (String selectedColumn : selectedColumns) {
                            row = res.getObject(selectedColumn);
                            results.add(row);
                        }
                    }
                    callback.onResult(results);
                }
            }
            catch (SQLException e) {
                callback.onError(e);
            }
        });
    }

    public void addColumn(final String table, final String column, final Callback<Boolean> callback) {
        this.isTableExistsAsync(table, new Callback<Boolean>(){
            final /* synthetic */ MySQLV2 this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                if (result.booleanValue()) {
                    String sql = "ALTER TABLE " + table + " ADD COLUMN " + column;
                    try (Connection conn = this.this$0.getConnection();
                         Statement stmt = conn.createStatement();){
                        stmt.executeUpdate(sql);
                        callback.onResult(true);
                    }
                    catch (SQLException ex) {
                        callback.onError(ex);
                    }
                }
            }

            @Override
            public void onError(Throwable t) {
                callback.onError(t);
            }
        });
    }

    public void removeColumn(final String table, final String column, final Callback<Boolean> callback) {
        this.isTableExistsAsync(table, new Callback<Boolean>(){
            final /* synthetic */ MySQLV2 this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                if (result.booleanValue()) {
                    String sql = "ALTER TABLE " + table + " DROP COLUMN " + column;
                    try (Connection conn = this.this$0.getConnection();
                         Statement stmt = conn.createStatement();){
                        stmt.executeUpdate(sql);
                        callback.onResult(true);
                    }
                    catch (SQLException ex) {
                        callback.onError(ex);
                    }
                }
            }

            @Override
            public void onError(Throwable t) {
                callback.onError(t);
            }
        });
    }

    public void showColumns(final String table, final Callback<List<String>> callback) {
        final ArrayList columns = new ArrayList();
        this.isTableExistsAsync(table, new Callback<Boolean>(){
            final /* synthetic */ MySQLV2 this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResult(Boolean result) {
                if (result.booleanValue()) {
                    String sql = "SHOW COLUMNS FROM " + table;
                    try (Connection conn = this.this$0.getConnection();
                         Statement stmt = conn.createStatement();
                         ResultSet resultSet = stmt.executeQuery(sql);){
                        while (resultSet.next()) {
                            columns.add(resultSet.getString("Field"));
                        }
                        callback.onResult(columns);
                    }
                    catch (SQLException ex) {
                        callback.onError(ex);
                    }
                }
            }

            @Override
            public void onError(Throwable t) {
                callback.onError(t);
            }
        });
    }

    public static interface Callback<T> {
        public void onResult(T var1);

        public void onError(Throwable var1);
    }

    public static class Builder {
        private String host;
        private String user;
        private String password;
        private int port;
        private String database;
        private boolean allowPublicKey = false;

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder database(String database) {
            this.database = database;
            return this;
        }

        public Builder allowPublicKey(boolean allowPublicKey) {
            this.allowPublicKey = allowPublicKey;
            return this;
        }

        public MySQLV2 build() {
            MySQLV2 mySQLV2 = new MySQLV2(this.host, this.user, this.password, this.port, this.database);
            mySQLV2.setAllowPublicKey(this.allowPublicKey);
            return mySQLV2;
        }
    }
}

