/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.yamlutils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.common.FlowStyle;
import org.snakeyaml.engine.v2.common.ScalarStyle;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.nodes.SequenceNode;
import org.snakeyaml.engine.v2.nodes.Tag;
import org.snakeyaml.engine.v2.representer.StandardRepresenter;

public class CustomRepresenter
extends StandardRepresenter {
    public CustomRepresenter(DumpSettings dumpSettings) {
        super(dumpSettings);
    }

    @Override
    public Node represent(Object data) {
        if (data == null) {
            return super.representData(null);
        }
        if (data instanceof Node) {
            return (Node)data;
        }
        if (data instanceof Enum) {
            Enum en = (Enum)data;
            String value = en.name();
            return new ScalarNode(Tag.STR, value, ScalarStyle.PLAIN);
        }
        if (this.isStandardJavaType(data)) {
            return super.representData(data);
        }
        if (data instanceof Collection) {
            Collection coll = (Collection)data;
            ArrayList<Node> children = new ArrayList<Node>();
            for (Object item : coll) {
                if (item instanceof Node) {
                    children.add((Node)item);
                    continue;
                }
                children.add(this.represent(item));
            }
            return new SequenceNode(Tag.SEQ, children, FlowStyle.BLOCK);
        }
        if (data instanceof Map) {
            Map mapData = (Map)data;
            ArrayList<NodeTuple> mapTuples = new ArrayList<NodeTuple>();
            for (Map.Entry e : mapData.entrySet()) {
                Node keyNode = e.getKey() instanceof Node ? (Node)e.getKey() : this.represent(e.getKey());
                Node valueNode = e.getValue() instanceof Node ? (Node)e.getValue() : this.represent(e.getValue());
                mapTuples.add(new NodeTuple(keyNode, valueNode));
            }
            return new MappingNode(Tag.MAP, mapTuples, FlowStyle.BLOCK);
        }
        ArrayList<NodeTuple> fieldTuples = new ArrayList<NodeTuple>();
        List<Field> allFields = this.getAllFields(data.getClass());
        for (Field field : allFields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                field.setAccessible(true);
                Object value = field.get(data);
                Node valueNode = value == null ? super.representData(null) : (value instanceof Node ? (Node)value : this.represent(value));
                Node keyNode = super.representData(field.getName());
                fieldTuples.add(new NodeTuple(keyNode, valueNode));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return new MappingNode(Tag.MAP, fieldTuples, FlowStyle.BLOCK);
    }

    private List<Field> getAllFields(Class<?> startClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> current = startClass; current != null && current != Object.class; current = current.getSuperclass()) {
            fields.addAll(Arrays.asList(current.getDeclaredFields()));
        }
        return fields;
    }

    private boolean isStandardJavaType(Object data) {
        return data instanceof String || data instanceof Number || data instanceof Boolean || data instanceof Character;
    }

    public static void main(String[] args) {
        DumpSettings dumpSettings = DumpSettings.builder().setDefaultFlowStyle(FlowStyle.BLOCK).setDefaultScalarStyle(ScalarStyle.PLAIN).build();
        CustomRepresenter myRepresenter = new CustomRepresenter(dumpSettings);
    }
}

