/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.yamlutils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.snakeyaml.engine.v2.api.Dump;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.common.FlowStyle;
import org.snakeyaml.engine.v2.common.ScalarStyle;
import org.snakeyaml.engine.v2.nodes.Tag;
import org.snakeyaml.engine.v2.representer.StandardRepresenter;

public class FileConfiguration {
    private final StandardRepresenter representer;
    private Map<String, Object> data = new LinkedHashMap<String, Object>();
    private final List<String> originalLines = new ArrayList<String>();
    private final Map<Integer, String> comments = new LinkedHashMap<Integer, String>();
    private final File file;
    private final LoadSettings loadSettings;
    private final DumpSettings dumpSettings;

    public FileConfiguration(File file) {
        this.file = file;
        this.loadSettings = LoadSettings.builder().setParseComments(true).build();
        this.dumpSettings = DumpSettings.builder().setDefaultScalarStyle(ScalarStyle.PLAIN).setDefaultFlowStyle(FlowStyle.BLOCK).build();
        this.representer = new StandardRepresenter(this.dumpSettings);
    }

    public FileConfiguration(File source, File file) {
        this.file = file;
        this.loadSettings = LoadSettings.builder().setParseComments(true).build();
        this.dumpSettings = DumpSettings.builder().setDefaultScalarStyle(ScalarStyle.PLAIN).setDefaultFlowStyle(FlowStyle.BLOCK).build();
        this.representer = new StandardRepresenter(this.dumpSettings);
        this.setDefaults(source, file);
        this.save();
    }

    public FileConfiguration() {
        this.file = null;
        this.loadSettings = LoadSettings.builder().setParseComments(true).build();
        this.dumpSettings = DumpSettings.builder().setDefaultScalarStyle(ScalarStyle.PLAIN).setDefaultFlowStyle(FlowStyle.BLOCK).build();
        this.representer = new StandardRepresenter(this.dumpSettings);
    }

    public void set(String path, Object value) {
        String[] keys = path.split("\\.");
        Map current = this.data;
        for (int i = 0; i < keys.length - 1; ++i) {
            current = (Map)current.computeIfAbsent((String)keys[i], k -> new LinkedHashMap());
        }
        if (current != null) {
            current.put(keys[keys.length - 1], value);
        }
    }

    public Object get(String path) {
        String[] keys = path.split("\\.");
        Map current = this.data;
        for (int i = 0; i < keys.length; ++i) {
            Object value = current.get(keys[i]);
            if (value == null) {
                return null;
            }
            if (i == keys.length - 1) {
                return value;
            }
            if (!(value instanceof Map)) {
                return null;
            }
            current = (Map)value;
        }
        return current;
    }

    public Object getOrDefault(String path, Object defaultValue) {
        String[] keys = path.split("\\.");
        Map current = this.data;
        for (int i = 0; i < keys.length; ++i) {
            Object value = current.get(keys[i]);
            if (value == null) {
                return null;
            }
            if (i == keys.length - 1) {
                return value;
            }
            if (!(value instanceof Map)) {
                return defaultValue;
            }
            current = (Map)value;
        }
        return current != null ? current : defaultValue;
    }

    public boolean containsKey(String key) {
        return this.get(key) != null;
    }

    public boolean containsValue(Object value) {
        return this.data.containsValue(value);
    }

    public FileConfiguration getConfigurationsSection(String path) {
        Object section = this.get(path);
        if (section instanceof Map) {
            FileConfiguration sectionConfig = new FileConfiguration();
            sectionConfig.data.putAll((Map)section);
            return sectionConfig;
        }
        System.out.println("DEBUG: Section not found for path: " + path);
        System.out.println("DEBUG: Actual data: " + String.valueOf(this.data));
        return null;
    }

    public List<String> getKeys(String path) {
        Map<String, Object> section = this.getMap(path);
        if (section != null) {
            Map<String, Object> sectionMap = section;
            return new ArrayList<String>(sectionMap.keySet());
        }
        System.out.println("DEBUG: Section not found for path: " + path);
        System.out.println("DEBUG: Actual data: " + String.valueOf(this.data));
        return null;
    }

    public void load(File file) {
        try (InputStream input = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            Load loader = new Load(this.loadSettings);
            Object loadedData = loader.loadFromInputStream(input);
            if (loadedData instanceof Map) {
                this.data.clear();
                this.data.putAll((Map)loadedData);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setDefaults(File source, File destination) {
        this.loadYAMLWithComments(source);
        FileConfiguration sourceConfig = new FileConfiguration(source);
        sourceConfig.loadYAMLWithComments();
        if (destination.exists()) {
            this.loadYAMLWithComments(destination);
        }
        this.deepMerge(sourceConfig.getData(), this.data);
        this.save();
    }

    private void deepMerge(Map<String, Object> source, Map<String, Object> destination) {
        if (destination == null) {
            destination = new LinkedHashMap<String, Object>();
        }
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String key = entry.getKey();
            Object sourceValue = entry.getValue();
            if (!destination.containsKey(key)) {
                destination.put(key, sourceValue);
                continue;
            }
            Object destinationValue = destination.get(key);
            if (!(sourceValue instanceof Map) || !(destinationValue instanceof Map)) continue;
            this.deepMerge((Map)sourceValue, (Map)destinationValue);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LinkedHashMap<String, Object> getDefaults(File file) {
        try (FileInputStream input = new FileInputStream(file);){
            Load loader = new Load(this.loadSettings);
            Object loadedData = loader.loadFromInputStream(input);
            if (!(loadedData instanceof Map)) return new LinkedHashMap<String, Object>();
            LinkedHashMap linkedHashMap = (LinkedHashMap)loadedData;
            return linkedHashMap;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return new LinkedHashMap<String, Object>();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new LinkedHashMap<String, Object>();
    }

    public void load() {
        if (this.file != null) {
            this.loadYAMLWithComments();
        } else {
            System.err.println("File is not specified for loading.");
        }
    }

    public void loadYAMLWithComments() {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.file));){
            String line;
            StringBuilder yamlDataBuilder = new StringBuilder();
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                this.originalLines.add(line);
                if (line.trim().startsWith("#")) {
                    this.comments.put(lineNumber, line);
                } else {
                    yamlDataBuilder.append(line).append("\n");
                }
                ++lineNumber;
            }
            Load loader = new Load(this.loadSettings);
            this.data = (Map)loader.loadFromString(yamlDataBuilder.toString());
            if (this.data == null) {
                this.data = new LinkedHashMap<String, Object>();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadYAMLWithComments(File file) {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            StringBuilder yamlDataBuilder = new StringBuilder();
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                this.originalLines.add(line);
                if (line.trim().startsWith("#")) {
                    this.comments.put(lineNumber, line);
                } else {
                    yamlDataBuilder.append(line).append("\n");
                }
                ++lineNumber;
            }
            Load loader = new Load(this.loadSettings);
            this.data = (Map)loader.loadFromString(yamlDataBuilder.toString());
            if (this.data == null) {
                this.data = new LinkedHashMap<String, Object>();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveYAMLWithComments() {
        if (this.file == null) {
            System.err.println("No file specified for saving.");
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.file));){
            Dump dumper = new Dump(this.dumpSettings, this.representer);
            String yamlData = dumper.dumpToString(this.data);
            List<String> yamlDataLines = Arrays.asList(yamlData.split("\n"));
            int dataLineIndex = 0;
            for (int i = 0; i < this.originalLines.size(); ++i) {
                if (this.comments.containsKey(i)) {
                    writer.write(this.comments.get(i) + "\n");
                    continue;
                }
                if (dataLineIndex >= yamlDataLines.size()) continue;
                writer.write(yamlDataLines.get(dataLineIndex) + "\n");
                ++dataLineIndex;
            }
            while (dataLineIndex < yamlDataLines.size()) {
                writer.write(yamlDataLines.get(dataLineIndex) + "\n");
                ++dataLineIndex;
            }
        }
        catch (IOException e) {
            System.err.println("Error writing YAML file: " + this.file.getPath());
            e.printStackTrace();
        }
    }

    private String extractKey(String line) {
        if (line.contains(":")) {
            return line.split(":")[0].trim();
        }
        return null;
    }

    public void save(File file) {
        this.saveYAMLWithComments();
    }

    public void save() {
        if (this.file != null) {
            this.save(this.file);
        }
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public void set(String path, Map<String, Object> value) {
        String[] keys = this.getArrays(path);
        Map current = this.data;
        for (int i = 0; i < keys.length - 1; ++i) {
            current = (Map)current.computeIfAbsent((String)keys[i], k -> new LinkedHashMap());
        }
        if (current != null) {
            current.put(keys[keys.length - 1], value);
        }
    }

    public String[] getArrays(String path) {
        return path.split("\\.");
    }

    public Map<String, Object> getMap(String path) {
        String[] keys = path.split("\\.");
        Map current = this.data;
        for (String key : keys) {
            Object value = current.get(key);
            if (value == null || !(value instanceof Map)) {
                return null;
            }
            current = (Map)value;
        }
        return current;
    }

    public Map<String, Object> getMapOrDefault(String path, Map<String, Object> defaultValue) {
        String[] keys = path.split("\\.");
        Map<Object, Object> current = this.data;
        for (String key : keys) {
            Object value = current.get(key);
            if (value == null || !(value instanceof Map)) {
                return defaultValue;
            }
            current = (Map<Object, Object>)value;
        }
        return current != null ? current : defaultValue;
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public String getString(String key, String defaultValue) {
        return this.get(key) != null ? (String)this.get(key) : defaultValue;
    }

    public boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.get(key) != null ? (Boolean)this.get(key) : defaultValue;
    }

    public int getInt(String key) {
        return (Integer)this.get(key);
    }

    public int getInt(String key, int defaultValue) {
        return this.get(key) != null ? (Integer)this.get(key) : defaultValue;
    }

    public double getDouble(String key) {
        return (Double)this.get(key);
    }

    public double getDouble(String key, double defaultValue) {
        return this.get(key) != null ? (Double)this.get(key) : defaultValue;
    }

    public long getLong(String key) {
        return (Long)this.get(key);
    }

    public long getLong(String key, long defaultValue) {
        return this.get(key) != null ? (Long)this.get(key) : defaultValue;
    }

    public float getFloat(String key) {
        return ((Float)this.get(key)).floatValue();
    }

    public float getFloat(String key, float defaultValue) {
        return this.get(key) != null ? ((Float)this.get(key)).floatValue() : defaultValue;
    }

    public List<?> getList(String key) {
        return (List)this.get(key);
    }

    public List<?> getList(String key, List<?> defaultValue) {
        return this.get(key) != null ? (List)this.get(key) : defaultValue;
    }

    public <T> List<T> getList(String key, Class<T> clazz) {
        List<?> list = this.getList(key);
        if (list != null) {
            if (list.stream().allMatch(clazz::isInstance)) {
                return list;
            }
        }
        throw new ClassCastException("The list contains elements of the wrong type or is null.");
    }

    public List<String> getStringList(String key) {
        return this.getList(key);
    }

    public void addClassPath(Tag tag, Class<?> clazz) {
        this.representer.addClassTag(clazz, tag);
    }
}

