/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.yamlutils;

import ch.framedev.yamlutils.CustomRepresenter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.snakeyaml.engine.v2.api.Dump;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.common.FlowStyle;
import org.snakeyaml.engine.v2.common.ScalarStyle;
import org.snakeyaml.engine.v2.constructor.StandardConstructor;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.Tag;
import org.snakeyaml.engine.v2.representer.StandardRepresenter;

public class YamlUtils {
    private final Load load;
    private final Dump dump;
    private final StandardRepresenter representer;
    private final StandardConstructor constructor;

    public YamlUtils() {
        LoadSettings loadSettings = LoadSettings.builder().setAllowDuplicateKeys(false).build();
        DumpSettings dumpSettings = DumpSettings.builder().setDefaultFlowStyle(FlowStyle.BLOCK).setDefaultScalarStyle(ScalarStyle.PLAIN).build();
        this.representer = new CustomRepresenter(dumpSettings);
        this.constructor = new StandardConstructor(loadSettings){

            @Override
            protected Object constructObject(Node node) {
                if (node instanceof MappingNode) {
                    Tag nodeTag = node.getTag();
                    if (Tag.MAP.equals(nodeTag)) {
                        return super.constructObject(node);
                    }
                    MappingNode mappingNode = (MappingNode)node;
                    try {
                        Class<?> clazz = Class.forName(nodeTag.getValue());
                        Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        return instance;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return super.constructObject(node);
            }
        };
        this.load = new Load(loadSettings, this.constructor);
        this.dump = new Dump(dumpSettings, this.representer);
    }

    public String objectToYamlString(Object object) {
        try {
            return this.dump.dumpToString(object);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> T classFromYamlString(String yaml, Class<T> clazz) {
        try {
            Object loaded = this.load.loadFromString(yaml);
            if (loaded instanceof Map) {
                return this.mapToClass((Map)loaded, clazz);
            }
            if (clazz.isInstance(loaded)) {
                return clazz.cast(loaded);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean saveYamlToFile(File file, Object object) {
        try {
            if (!file.exists()) {
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
                if (!file.createNewFile()) {
                    return false;
                }
            }
            try (FileWriter writer = new FileWriter(file);){
                writer.write(this.dump.dumpToString(object));
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T getClassFromYamlFile(File file, Class<T> clazz) {
        if (file.exists() && file.isFile()) {
            try (FileReader reader = new FileReader(file);){
                Object loaded = this.load.loadFromReader(reader);
                if (loaded instanceof Map) {
                    T t = this.mapToClass((Map)loaded, clazz);
                    return t;
                }
                if (!clazz.isInstance(loaded)) return null;
                T t = clazz.cast(loaded);
                return t;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        System.err.println("File doesn't exist or is not a valid file: " + file.getPath());
        return null;
    }

    private <T> T mapToClass(Map<?, ?> map, Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            T instance = constructor.newInstance(new Object[0]);
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                String key = entry.getKey().toString();
                Object value = entry.getValue();
                Field field = this.findFieldInHierarchy(clazz, key);
                if (field == null) {
                    System.err.println("No such field in " + clazz.getName() + " (or superclasses): " + key);
                    continue;
                }
                field.setAccessible(true);
                if (Map.class.isAssignableFrom(field.getType())) {
                    HashMap mapField = new HashMap();
                    if (value instanceof Map) {
                        Map nestedMap = (Map)value;
                        for (Map.Entry nestedEntry : nestedMap.entrySet()) {
                            mapField.put(nestedEntry.getKey(), nestedEntry.getValue());
                        }
                    }
                    field.set(instance, mapField);
                    continue;
                }
                if (field.getType().isEnum()) {
                    if (value instanceof String) {
                        Class<?> enumClass = field.getType();
                        Object enumValue = Enum.valueOf(enumClass, (String)value);
                        field.set(instance, enumValue);
                        continue;
                    }
                    System.err.println("Cannot assign non-String '" + String.valueOf(value) + "' to enum field '" + key + "'.");
                    continue;
                }
                if (value instanceof Map) {
                    Class<?> fieldType = field.getType();
                    Object nestedObject = this.mapToClass((Map)value, fieldType);
                    field.set(instance, nestedObject);
                    continue;
                }
                field.set(instance, value);
            }
            return instance;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Field findFieldInHierarchy(Class<?> clazz, String fieldName) {
        for (Class<?> current = clazz; current != null && current != Object.class; current = current.getSuperclass()) {
            try {
                return current.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }
}

