package ch.framedev.simplejavautils;

public enum Time {

    SECONDS(1),
    MINUTES(60),
    HOURS(3600),
    DAYS(86400),
    WEEKS(604800),
    MONTHS(2628000),  // Approximate (30.44 days)
    YEARS(31536000);  // Approximate (365.25 days)

    private final long seconds;

    Time(long seconds) {
        this.seconds = seconds;
    }

    public long getSeconds() {
        return seconds;
    }

    /**
     * Converts a time value from one unit to another.
     *
     * @param value The value to convert.
     * @param from  The original unit.
     * @param to    The target unit.
     * @return The converted value.
     */
    public static double convert(long value, Time from, Time to) {
        return (double) value * from.seconds / to.seconds;
    }

    /**
     * Converts a value in this unit to another unit.
     *
     * @param value The value to convert.
     * @param to    The target unit.
     * @return The converted value.
     */
    public double convertTo(long value, Time to) {
        return convert(value, this, to);
    }

    @Override
    public String toString() {
        return this.name() + " (" + seconds + " seconds)";
    }
}