/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.simplejavautils;

import ch.framedev.simplejavautils.SimpleJavaUtils;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.logging.Level;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PasswordHasher {
    private static final String ALGO = "PBKDF2WithHmacSHA1";
    private static final byte[] SALT = new byte[]{8, 8, 8, 8, 2, 8, 7, 7, 7, 2, 1, 1, 1, 1, 2, 11};
    private static final int ITERATION_COUNT = 1000;
    private static final int KEY_LENGTH = 128;
    private SecretKeyFactory mFactory;

    public byte[] hashPassword(String password) {
        SecretKeyFactory factory = this.getFactory();
        if (factory != null) {
            try {
                PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), SALT, 1000, 128);
                return factory.generateSecret(spec).getEncoded();
            }
            catch (InvalidKeySpecException e) {
                SimpleJavaUtils.logger.log(Level.SEVERE, "Error", e);
            }
        }
        return null;
    }

    public boolean verifyPassword(String password, byte[] expectedHashResult) {
        byte[] hashedPassword = this.hashPassword(password);
        if (hashedPassword == null) {
            return false;
        }
        return Arrays.equals(hashedPassword, expectedHashResult);
    }

    private SecretKeyFactory getFactory() {
        if (this.mFactory == null) {
            try {
                this.mFactory = SecretKeyFactory.getInstance(ALGO);
            }
            catch (NoSuchAlgorithmException e) {
                SimpleJavaUtils.logger.log(Level.SEVERE, "Error", e);
            }
        }
        return this.mFactory;
    }
}

