/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev;

import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class YamlParser {
    public String serialize(Object obj) throws IllegalAccessException {
        return this.serialize(obj, 0);
    }

    private String serialize(Object obj, int indent) throws IllegalAccessException {
        if (obj == null) {
            return "null";
        }
        if (obj.getClass().isEnum() || this.isPrimitiveOrString(obj)) {
            return obj.toString();
        }
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
        for (Class<?> clazz = obj.getClass(); clazz != null && clazz != Object.class && !clazz.getName().startsWith("java."); clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if ((field.getModifiers() & 8) != 0) continue;
                field.setAccessible(true);
                fields.put(field.getName(), field.get(obj));
            }
        }
        String indentStr = "  ".repeat(indent);
        for (Map.Entry entry : fields.entrySet()) {
            int itemIndent;
            Object value = entry.getValue();
            if (this.isPrimitiveOrString(value)) {
                sb.append(indentStr).append((String)entry.getKey()).append(": ").append(value).append("\n");
                continue;
            }
            if (value == null) {
                sb.append(indentStr).append((String)entry.getKey()).append(": null\n");
                continue;
            }
            if (value instanceof Enum) {
                sb.append(indentStr).append((String)entry.getKey()).append(": ").append(value.toString()).append("\n");
                continue;
            }
            if (value instanceof Collection) {
                sb.append(indentStr).append((String)entry.getKey()).append(":\n");
                itemIndent = indent + 1;
                for (Object e : (Collection)value) {
                    sb.append("  ".repeat(itemIndent)).append("- ").append(this.serialize(e, itemIndent)).append("\n");
                }
                continue;
            }
            if (value instanceof Map) {
                sb.append(indentStr).append((String)entry.getKey()).append(":\n");
                itemIndent = indent + 1;
                for (Map.Entry entry2 : ((Map)value).entrySet()) {
                    Object mapVal = entry2.getValue();
                    sb.append("  ".repeat(itemIndent)).append(entry2.getKey()).append(":");
                    if (mapVal instanceof Collection) {
                        sb.append("\n");
                        for (Object item : (Collection)mapVal) {
                            sb.append("  ".repeat(itemIndent + 1)).append("- ").append(this.serialize(item, itemIndent + 1)).append("\n");
                        }
                        continue;
                    }
                    if (mapVal instanceof Map) {
                        sb.append("\n").append(this.serialize(mapVal, itemIndent + 1));
                        continue;
                    }
                    if (mapVal == null) {
                        sb.append(" null\n");
                        continue;
                    }
                    sb.append(" ").append(this.serialize(mapVal, itemIndent)).append("\n");
                }
                continue;
            }
            sb.append(indentStr).append((String)entry.getKey()).append(":\n");
            sb.append(this.serialize(value, indent + 1));
        }
        return sb.toString();
    }

    private boolean isPrimitiveOrString(Object value) {
        if (value == null) {
            return true;
        }
        Class<?> type = value.getClass();
        return type.isPrimitive() || type == String.class || Number.class.isAssignableFrom(type) || type == Boolean.class || type == Character.class;
    }

    public <T> T deserialize(String yaml, Class<T> clazz) throws Exception {
        List<String> lines = Arrays.asList(yaml.split("\n"));
        return this.deserializeObject(lines, clazz, (int)0, (int)0).obj;
    }

    private <T> ParseResult<T> deserializeObject(List<String> lines, Class<T> clazz, int startLine, int indent) throws Exception {
        if (clazz.isEnum()) {
            String value = lines.get(startLine).trim();
            T enumValue = Enum.valueOf(clazz, value);
            return new ParseResult<T>(enumValue, startLine + 1);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            ArrayList<String> collection = new ArrayList<String>();
            int i = startLine;
            while (i < lines.size()) {
                String line = lines.get(i);
                if (line.trim().isEmpty()) {
                    ++i;
                    continue;
                }
                int currentIndent = this.countIndent(line);
                if (currentIndent < indent || !(line = line.trim()).startsWith("- ")) break;
                String value = line.substring(2).trim();
                collection.add(value);
                ++i;
            }
            ArrayList<String> result = collection;
            return new ParseResult(result, i);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            int i = startLine;
            while (i < lines.size()) {
                String line = lines.get(i);
                if (line.trim().isEmpty()) {
                    ++i;
                    continue;
                }
                int currentIndent = this.countIndent(line);
                if (currentIndent < indent || !(line = line.trim()).contains(":")) break;
                String[] parts = line.split(":", 2);
                String key = parts[0].trim();
                String value = parts[1].trim();
                if (value.isEmpty()) {
                    int j = i + 1;
                    if (j < lines.size() && lines.get(j).trim().startsWith("- ")) {
                        ArrayList<String> list = new ArrayList<String>();
                        while (j < lines.size() && this.countIndent(lines.get(j)) == indent + 1 && lines.get(j).trim().startsWith("- ")) {
                            list.add(lines.get(j).trim().substring(2).trim());
                            ++j;
                        }
                        map.put(key, list);
                        i = j;
                        continue;
                    }
                    if (j < lines.size() && this.countIndent(lines.get(j)) == indent + 1 && lines.get(j).contains(":")) {
                        ParseResult<Map> nested = this.deserializeObject(lines, Map.class, j, indent + 1);
                        map.put(key, nested.obj);
                        i = nested.nextLine;
                        continue;
                    }
                    map.put(key, null);
                    ++i;
                    continue;
                }
                map.put(key, value);
                ++i;
            }
            HashMap<String, Object> result = map;
            return new ParseResult(result, i);
        }
        T obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        int i = startLine;
        while (i < lines.size()) {
            String line = lines.get(i);
            if (line.trim().isEmpty()) {
                ++i;
                continue;
            }
            int currentIndent = this.countIndent(line);
            if (currentIndent < indent) break;
            if ((line = line.trim()).endsWith(":")) {
                String fieldName = line.substring(0, line.length() - 1).trim();
                Field field = this.getField(clazz, fieldName);
                if (field == null) {
                    ++i;
                    continue;
                }
                field.setAccessible(true);
                Class<?> fieldType = field.getType();
                if (Collection.class.isAssignableFrom(fieldType)) {
                    int j;
                    ArrayList<String> items = new ArrayList<String>();
                    for (j = i + 1; j < lines.size() && this.countIndent(lines.get(j)) == indent + 1 && lines.get(j).trim().startsWith("- "); ++j) {
                        items.add(lines.get(j).trim().substring(2).trim());
                    }
                    ArrayList collection = new ArrayList(items);
                    field.set(obj, collection);
                    i = j;
                    continue;
                }
                if (Map.class.isAssignableFrom(fieldType)) {
                    int j;
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (j = i + 1; j < lines.size() && this.countIndent(lines.get(j)) == indent + 1 && lines.get(j).contains(":"); ++j) {
                        String[] parts = lines.get(j).trim().split(":", 2);
                        String key = parts[0].trim();
                        String value = parts[1].trim();
                        map.put(key, value);
                    }
                    field.set(obj, map);
                    i = j;
                    continue;
                }
                ParseResult<?> nested = this.deserializeObject(lines, fieldType, i + 1, indent + 1);
                field.set(obj, nested.obj);
                i = nested.nextLine;
                continue;
            }
            String[] parts = line.split(":", 2);
            if (parts.length == 2) {
                String fieldName = parts[0].trim();
                String value = parts[1].trim();
                Field field = this.getField(clazz, fieldName);
                if (field != null) {
                    field.setAccessible(true);
                    if (field.getType().isEnum()) {
                        Object enumValue = Enum.valueOf(field.getType(), value);
                        field.set(obj, enumValue);
                    } else {
                        field.set(obj, this.castValue(field.getType(), value));
                    }
                }
            }
            ++i;
        }
        return new ParseResult<T>(obj, i);
    }

    private int countIndent(String line) {
        int count = 0;
        while (line.startsWith("  ")) {
            ++count;
            line = line.substring(2);
        }
        return count;
    }

    private Field getField(Class<?> clazz, String name) {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            try {
                return current.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return null;
    }

    private Object castValue(Class<?> type, String value) {
        if ("null".equals(value)) {
            return null;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer.parseInt(value);
        }
        if (type == Long.TYPE || type == Long.class) {
            return Long.parseLong(value);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (type == Double.TYPE || type == Double.class) {
            return Double.parseDouble(value);
        }
        return value;
    }

    public void toFile(File file, Object obj) throws Exception {
        String yaml = this.serialize(obj);
        try (FileWriter writer = new FileWriter(file);){
            writer.write(yaml);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public <T> T fromFile(File file, Class<T> clazz) throws Exception {
        ArrayList<String> lines = null;
        try (Scanner scanner = new Scanner(file);){
            lines = new ArrayList<String>();
            while (scanner.hasNextLine()) {
                lines.add(scanner.nextLine());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String yaml = String.join((CharSequence)"\n", lines);
        return this.deserialize(yaml, clazz);
    }

    private static class ParseResult<T> {
        T obj;
        int nextLine;

        ParseResult(T obj, int nextLine) {
            this.obj = obj;
            this.nextLine = nextLine;
        }
    }
}

