/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.builtin;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializationException;

final class IntegralNumberDeserializationUtil {
    private IntegralNumberDeserializationUtil() {
    }

    static long deserialize(Number number) throws JsonDeserializationException {
        Objects.requireNonNull(number, "number");
        if (number instanceof Long) {
            Long l = (Long)number;
            return l;
        }
        if (number instanceof Integer) {
            Integer i = (Integer)number;
            return i.intValue();
        }
        if (number instanceof Short) {
            Short s = (Short)number;
            return s.shortValue();
        }
        if (number instanceof Byte) {
            Byte b = (Byte)number;
            return b.byteValue();
        }
        if (number instanceof Double) {
            Double d = (Double)number;
            return IntegralNumberDeserializationUtil.deserializeFromDouble(d);
        }
        if (number instanceof Float) {
            Float f = (Float)number;
            return IntegralNumberDeserializationUtil.deserializeFromDouble(f.floatValue());
        }
        if (number instanceof BigInteger) {
            BigInteger bi = (BigInteger)number;
            try {
                return bi.longValueExact();
            }
            catch (ArithmeticException _ignored) {
                throw new JsonDeserializationException("value out of bounds: " + String.valueOf(bi));
            }
        }
        if (number instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)number;
            try {
                return bd.longValueExact();
            }
            catch (ArithmeticException _ignored) {
                throw new JsonDeserializationException("value out of bounds or has unexpected fractional digits: " + String.valueOf(bd));
            }
        }
        return number.longValue();
    }

    private static long deserializeFromDouble(double original) throws JsonDeserializationException {
        long converted = (long)original;
        double convertedBack = converted;
        if (convertedBack != original) {
            throw new JsonDeserializationException("value out of bounds or has unexpected fractional digits: " + original);
        }
        return converted;
    }

    static void verifyBounds(long original, long converted) throws JsonDeserializationException {
        if (converted != original) {
            throw new JsonDeserializationException("value out of bounds: " + original);
        }
    }
}

