/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.builtin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import name.martingeisse.grumpyjson.FieldErrorNode;
import name.martingeisse.grumpyjson.JsonRegistries;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializationException;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializer;
import name.martingeisse.grumpyjson.registry.NotRegisteredException;
import name.martingeisse.grumpyjson.serialize.JsonSerializationException;
import name.martingeisse.grumpyjson.serialize.JsonSerializer;
import name.martingeisse.grumpyjson.util.TypeUtil;

public final class MapConverter
implements JsonSerializer<Map<?, ?>>,
JsonDeserializer {
    private final JsonRegistries registries;

    public MapConverter(JsonRegistries registries) {
        this.registries = registries;
    }

    @Override
    public boolean supportsTypeForDeserialization(Type type) {
        Objects.requireNonNull(type, "type");
        return TypeUtil.isParameterizedType(type, Map.class, 2) != null;
    }

    private static String buildFromJsonFieldName(boolean isAtKey, String key) {
        return (isAtKey ? "key[" : "value[") + key + "]";
    }

    @Override
    public Map<?, ?> deserialize(JsonElement json, Type type) throws JsonDeserializationException {
        Objects.requireNonNull(json, "json");
        Objects.requireNonNull(type, "type");
        if (json instanceof JsonObject) {
            JsonDeserializer valueDeserializer;
            JsonDeserializer keyDeserializer;
            JsonObject map = (JsonObject)json;
            Type[] keyAndValueTypes = TypeUtil.expectParameterizedType(type, List.class, 2);
            Type keyType = keyAndValueTypes[0];
            Type valueType = keyAndValueTypes[1];
            try {
                keyDeserializer = this.registries.getDeserializer(keyType);
                valueDeserializer = this.registries.getDeserializer(valueType);
            }
            catch (NotRegisteredException e) {
                throw new JsonDeserializationException(e.getMessage());
            }
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            FieldErrorNode errorNode = null;
            for (Map.Entry entry : map.entrySet()) {
                String keyText = (String)entry.getKey();
                boolean isAtKey = true;
                try {
                    Object key = keyDeserializer.deserialize((JsonElement)new JsonPrimitive(keyText), keyType);
                    isAtKey = false;
                    Object value = valueDeserializer.deserialize((JsonElement)entry.getValue(), valueType);
                    result.put(key, value);
                }
                catch (JsonDeserializationException e) {
                    errorNode = e.getFieldErrorNode().in(MapConverter.buildFromJsonFieldName(isAtKey, keyText)).and(errorNode);
                }
                catch (Exception e) {
                    errorNode = FieldErrorNode.create(e).in(MapConverter.buildFromJsonFieldName(isAtKey, keyText)).and(errorNode);
                }
            }
            if (errorNode != null) {
                throw new JsonDeserializationException(errorNode);
            }
            return Map.copyOf(result);
        }
        throw new JsonDeserializationException("expected object, found: " + String.valueOf(json));
    }

    @Override
    public boolean supportsClassForSerialization(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return Map.class.isAssignableFrom(clazz);
    }

    @Override
    public JsonElement serialize(Map<?, ?> map) throws JsonSerializationException {
        Objects.requireNonNull(map, "value");
        JsonObject result = new JsonObject();
        FieldErrorNode errorNode = null;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            JsonPrimitive p;
            JsonElement keyJson;
            Object keyObject = entry.getKey();
            if (keyObject == null) {
                throw new JsonSerializationException("map contains null key");
            }
            try {
                keyJson = this.registries.serialize(keyObject);
            }
            catch (JsonSerializationException e) {
                errorNode = e.getFieldErrorNode().in("[" + String.valueOf(keyObject) + "]").and(errorNode);
                continue;
            }
            catch (Exception e) {
                errorNode = FieldErrorNode.create(e).in("[" + String.valueOf(keyObject) + "]").and(errorNode);
                continue;
            }
            if (!(keyJson instanceof JsonPrimitive) || !(p = (JsonPrimitive)keyJson).isString()) {
                errorNode = FieldErrorNode.create("map key does not serialize to a JSON string").in("[" + String.valueOf(keyObject) + "]").and(errorNode);
                continue;
            }
            String keyText = keyJson.getAsString();
            try {
                Object valueObject = entry.getValue();
                if (valueObject == null) {
                    throw new JsonSerializationException("map contains null value");
                }
                JsonElement valueJson = this.registries.serialize(valueObject);
                result.add(keyText, valueJson);
            }
            catch (JsonSerializationException e) {
                errorNode = e.getFieldErrorNode().in(keyText).and(errorNode);
            }
            catch (Exception e) {
                errorNode = FieldErrorNode.create(e).in(keyText).and(errorNode);
            }
        }
        if (errorNode != null) {
            throw new JsonSerializationException(errorNode);
        }
        return result;
    }
}

