/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.builtin.helper_types;

import java.util.Objects;
import java.util.function.Supplier;

public final class OptionalField<T> {
    private final T value;

    private OptionalField(T value) {
        this.value = value;
    }

    public static <T> OptionalField<T> ofValue(T value) {
        return new OptionalField<T>(Objects.requireNonNull(value, "value"));
    }

    public static <T> OptionalField<T> ofNothing() {
        return new OptionalField<Object>(null);
    }

    public static <T> OptionalField<T> ofValueOrNullAsNothing(T value) {
        return new OptionalField<T>(value);
    }

    public T getValueOrNothingAsNull() {
        return this.value;
    }

    public T getValue() {
        if (this.value == null) {
            throw new IllegalStateException("this OptionalField is absent");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public boolean isAbsent() {
        return this.value == null;
    }

    public T orElse(T other) {
        return this.value == null ? other : this.value;
    }

    public T orElseGet(Supplier<T> other) {
        Objects.requireNonNull(other, "other");
        return this.value == null ? other.get() : this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OptionalField that = (OptionalField)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "OptionalField{value=" + String.valueOf(this.value) + "}";
    }
}

