/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.builtin.helper_types;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import name.martingeisse.grumpyjson.JsonRegistries;
import name.martingeisse.grumpyjson.builtin.helper_types.OptionalField;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializationException;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializer;
import name.martingeisse.grumpyjson.serialize.JsonSerializationException;
import name.martingeisse.grumpyjson.serialize.JsonSerializer;
import name.martingeisse.grumpyjson.util.TypeUtil;

public final class OptionalFieldConverter
implements JsonSerializer<OptionalField<?>>,
JsonDeserializer {
    private final JsonRegistries registries;

    public OptionalFieldConverter(JsonRegistries registries) {
        Objects.requireNonNull(registries, "registries");
        this.registries = registries;
    }

    @Override
    public boolean supportsTypeForDeserialization(Type type) {
        Objects.requireNonNull(type, "type");
        return TypeUtil.isSingleParameterizedType(type, OptionalField.class) != null;
    }

    @Override
    public OptionalField<?> deserialize(JsonElement json, Type type) throws JsonDeserializationException {
        Objects.requireNonNull(json, "json");
        Objects.requireNonNull(type, "type");
        try {
            return OptionalField.ofValue(this.registries.deserialize(json, this.getInner(type)));
        }
        catch (Exception e) {
            throw new JsonDeserializationException(e);
        }
    }

    @Override
    public OptionalField<?> deserializeAbsent(Type type) {
        Objects.requireNonNull(type, "type");
        this.getInner(type);
        return OptionalField.ofNothing();
    }

    @Override
    public boolean supportsClassForSerialization(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return clazz.equals(OptionalField.class);
    }

    @Override
    public JsonElement serialize(OptionalField<?> value) throws JsonSerializationException {
        Objects.requireNonNull(value, "value");
        throw new JsonSerializationException("found OptionalField in a non-vanishable context");
    }

    @Override
    public Optional<JsonElement> serializeOptional(OptionalField<?> value) throws JsonSerializationException {
        Objects.requireNonNull(value, "value");
        if (value.isAbsent()) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.registries.serialize(value.getValueOrNothingAsNull()));
        }
        catch (Exception e) {
            throw new JsonSerializationException(e);
        }
    }

    private Type getInner(Type outer) {
        Objects.requireNonNull(outer, "outer");
        return TypeUtil.expectSingleParameterizedType(outer, OptionalField.class);
    }
}

