/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.deserialize;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.Objects;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializationException;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializer;
import name.martingeisse.grumpyjson.registry.NotRegisteredException;

public interface JsonDeserializerProvider {
    public boolean supportsTypeForDeserialization(Type var1);

    public JsonDeserializer getDeserializer(Type var1) throws NotRegisteredException;

    default public Object deserialize(JsonElement source, Type type) throws JsonDeserializationException {
        JsonDeserializer deserializer;
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(type, "type");
        try {
            deserializer = this.getDeserializer(type);
        }
        catch (NotRegisteredException e) {
            throw new JsonDeserializationException("no deserializer registered for type: " + String.valueOf(type));
        }
        return deserializer.deserialize(source, type);
    }

    default public Object deserializeAbsent(Type type) throws JsonDeserializationException {
        JsonDeserializer deserializer;
        Objects.requireNonNull(type, "type");
        try {
            deserializer = this.getDeserializer(type);
        }
        catch (NotRegisteredException e) {
            throw new JsonDeserializationException("no deserializer registered for type: " + String.valueOf(type));
        }
        return deserializer.deserializeAbsent(type);
    }
}

