/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.serialize;

import java.util.Objects;
import name.martingeisse.grumpyjson.builtin.EnumConverter;
import name.martingeisse.grumpyjson.builtin.record.RecordConverterFactory;
import name.martingeisse.grumpyjson.registry.NotRegisteredException;
import name.martingeisse.grumpyjson.registry.Registry;
import name.martingeisse.grumpyjson.serialize.JsonSerializer;
import name.martingeisse.grumpyjson.serialize.JsonSerializerProvider;

public final class JsonSerializerRegistry
extends Registry<Class<?>, JsonSerializer<?>>
implements JsonSerializerProvider {
    private final RecordConverterFactory recordConverterFactory;

    public JsonSerializerRegistry(RecordConverterFactory recordConverterFactory) {
        Objects.requireNonNull(recordConverterFactory, "recordConverterFactory");
        this.recordConverterFactory = recordConverterFactory;
    }

    @Override
    protected boolean registrableSupports(JsonSerializer<?> registrable, Class<?> key) {
        Objects.requireNonNull(registrable, "registrable");
        Objects.requireNonNull(key, "key");
        return registrable.supportsClassForSerialization(key);
    }

    @Override
    protected JsonSerializer<?> generateRegistrable(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        if (clazz.isRecord()) {
            return this.recordConverterFactory.getSerializer(clazz);
        }
        if (clazz.isEnum()) {
            return new EnumConverter(clazz);
        }
        return null;
    }

    @Override
    protected String getErrorMessageForUnknownKey(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return "no JSON serializer found and can only auto-generate them for record classes, found class: " + String.valueOf(clazz);
    }

    @Override
    public boolean supportsClassForSerialization(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return this.supports(clazz);
    }

    @Override
    public <T> JsonSerializer<T> getSerializer(Class<T> clazz) throws NotRegisteredException {
        Objects.requireNonNull(clazz, "clazz");
        return (JsonSerializer)this.get(clazz);
    }
}

