/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.Strictness;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import name.martingeisse.grumpyjson.GsonTreeMapper;
import name.martingeisse.grumpyjson.JsonEngine;
import name.martingeisse.grumpyjson.TypeToken;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializationException;
import name.martingeisse.grumpyjson.json_model.JsonElement;
import name.martingeisse.grumpyjson.serialize.JsonSerializationException;

public final class GsonBasedJsonEngine
extends JsonEngine {
    private final Gson gson = new GsonBuilder().setStrictness(Strictness.STRICT).setPrettyPrinting().serializeNulls().create();
    private static final Pattern GSON_SYNTAX_ERROR_LOCATION_PATTERN = Pattern.compile("at line (\\d+) column (\\d+) ");

    @Override
    public <T> T deserialize(String source, Class<T> clazz) throws JsonDeserializationException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(clazz, "clazz");
        return this.deserialize(GsonBasedJsonEngine.wrapSource(source), clazz);
    }

    @Override
    public <T> T deserialize(String source, TypeToken<T> typeToken) throws JsonDeserializationException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(typeToken, "typeToken");
        return this.deserialize(GsonBasedJsonEngine.wrapSource(source), typeToken);
    }

    @Override
    public Object deserialize(String source, Type type) throws JsonDeserializationException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(type, "type");
        return this.deserialize(GsonBasedJsonEngine.wrapSource(source), type);
    }

    @Override
    public <T> T deserialize(InputStream source, Class<T> clazz) throws JsonDeserializationException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(clazz, "clazz");
        return this.deserialize(GsonBasedJsonEngine.wrapSource(source), clazz);
    }

    @Override
    public <T> T deserialize(InputStream source, TypeToken<T> typeToken) throws JsonDeserializationException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(typeToken, "typeToken");
        return this.deserialize(GsonBasedJsonEngine.wrapSource(source), typeToken);
    }

    @Override
    public Object deserialize(InputStream source, Type type) throws JsonDeserializationException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(type, "type");
        return this.deserialize(GsonBasedJsonEngine.wrapSource(source), type);
    }

    @Override
    public <T> T deserialize(Reader source, Class<T> clazz) throws JsonDeserializationException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(clazz, "clazz");
        return clazz.cast(this.deserialize(source, (Type)clazz));
    }

    @Override
    public <T> T deserialize(Reader source, TypeToken<T> typeToken) throws JsonDeserializationException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(typeToken, "typeToken");
        return (T)this.deserialize(source, typeToken.getType());
    }

    @Override
    public Object deserialize(Reader source, Type type) throws JsonDeserializationException {
        JsonElement json;
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(type, "type");
        try {
            com.google.gson.JsonElement gsonElement = (com.google.gson.JsonElement)this.gson.fromJson(source, com.google.gson.JsonElement.class);
            if (gsonElement == null) {
                throw new JsonDeserializationException("no JSON to deserialize");
            }
            json = GsonTreeMapper.mapFromGson(gsonElement);
        }
        catch (JsonSyntaxException e) {
            throw new JsonDeserializationException(GsonBasedJsonEngine.mapGsonErrorMessage(e.getMessage()));
        }
        catch (JsonIOException e) {
            throw new JsonDeserializationException("I/O error while reading JSON");
        }
        if (json == null) {
            throw new JsonDeserializationException("no JSON to deserialize");
        }
        return this.deserialize(json, type);
    }

    private static String mapGsonErrorMessage(String message) {
        Objects.requireNonNull(message, "message");
        Matcher matcher = GSON_SYNTAX_ERROR_LOCATION_PATTERN.matcher(message);
        if (matcher.find()) {
            return "syntax error in JSON at line " + matcher.group(1) + ", column " + matcher.group(2);
        }
        return "syntax error in JSON";
    }

    private static Reader wrapSource(String source) {
        Objects.requireNonNull(source, "source");
        return new StringReader(source);
    }

    private static Reader wrapSource(InputStream source) {
        Objects.requireNonNull(source, "source");
        return new InputStreamReader(source, StandardCharsets.UTF_8);
    }

    @Override
    public String serializeToString(Object value) throws JsonSerializationException {
        Objects.requireNonNull(value, "value");
        StringWriter writer = new StringWriter();
        this.writeTo(value, writer);
        return writer.toString();
    }

    @Override
    public void writeTo(Object value, OutputStream destination) throws JsonSerializationException {
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(destination, "destination");
        OutputStreamWriter writer = new OutputStreamWriter(destination, StandardCharsets.UTF_8);
        this.writeTo(value, writer);
        try {
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void writeTo(Object value, Writer destination) throws JsonSerializationException {
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(destination, "destination");
        JsonElement json = this.toJsonElement(value);
        com.google.gson.JsonElement gsonElement = GsonTreeMapper.mapToGson(json);
        this.gson.toJson(gsonElement, (Appendable)destination);
    }
}

