/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson;

import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import name.martingeisse.grumpyjson.json_model.JsonArray;
import name.martingeisse.grumpyjson.json_model.JsonBoolean;
import name.martingeisse.grumpyjson.json_model.JsonElement;
import name.martingeisse.grumpyjson.json_model.JsonNull;
import name.martingeisse.grumpyjson.json_model.JsonNumber;
import name.martingeisse.grumpyjson.json_model.JsonObject;
import name.martingeisse.grumpyjson.json_model.JsonString;
import name.martingeisse.grumpyjson.util.Parameters;

final class GsonTreeMapper {
    private GsonTreeMapper() {
    }

    static JsonElement mapFromGson(com.google.gson.JsonElement gsonElement) {
        Parameters.notNull(gsonElement, "gsonElement");
        if (gsonElement.isJsonNull()) {
            return JsonNull.INSTANCE;
        }
        if (gsonElement.isJsonPrimitive()) {
            JsonPrimitive primitive = gsonElement.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                return JsonBoolean.of(primitive.getAsBoolean());
            }
            if (primitive.isNumber()) {
                return JsonNumber.of(primitive.getAsNumber());
            }
            if (primitive.isString()) {
                return JsonString.of(primitive.getAsString());
            }
            throw new IllegalArgumentException("unknown primitive type: " + String.valueOf(primitive));
        }
        if (gsonElement.isJsonArray()) {
            ArrayList<JsonElement> mappedChildren = new ArrayList<JsonElement>();
            for (com.google.gson.JsonElement gsonChild : gsonElement.getAsJsonArray()) {
                mappedChildren.add(GsonTreeMapper.mapFromGson(gsonChild));
            }
            return JsonArray.of(mappedChildren);
        }
        if (gsonElement.isJsonObject()) {
            HashMap<String, JsonElement> mappedProperties = new HashMap<String, JsonElement>();
            for (Map.Entry gsonEntry : gsonElement.getAsJsonObject().entrySet()) {
                mappedProperties.put((String)gsonEntry.getKey(), GsonTreeMapper.mapFromGson((com.google.gson.JsonElement)gsonEntry.getValue()));
            }
            return JsonObject.of(mappedProperties);
        }
        throw new IllegalArgumentException("unknown element type: " + String.valueOf(gsonElement));
    }

    static com.google.gson.JsonElement mapToGson(JsonElement jsonElement) {
        Parameters.notNull(jsonElement, "jsonElement");
        if (jsonElement instanceof JsonNull) {
            return com.google.gson.JsonNull.INSTANCE;
        }
        if (jsonElement instanceof JsonBoolean) {
            JsonBoolean b = (JsonBoolean)jsonElement;
            return new JsonPrimitive(Boolean.valueOf(b.getValue()));
        }
        if (jsonElement instanceof JsonNumber) {
            JsonNumber n = (JsonNumber)jsonElement;
            return new JsonPrimitive(n.getValue());
        }
        if (jsonElement instanceof JsonString) {
            JsonString s = (JsonString)jsonElement;
            return new JsonPrimitive(s.getValue());
        }
        if (jsonElement instanceof JsonArray) {
            JsonArray a = (JsonArray)jsonElement;
            com.google.gson.JsonArray result = new com.google.gson.JsonArray();
            for (JsonElement child : a.getAsList()) {
                result.add(GsonTreeMapper.mapToGson(child));
            }
            return result;
        }
        if (jsonElement instanceof JsonObject) {
            JsonObject o = (JsonObject)jsonElement;
            com.google.gson.JsonObject result = new com.google.gson.JsonObject();
            for (Map.Entry<String, JsonElement> entry : o.getAsMap().entrySet()) {
                result.add(entry.getKey(), GsonTreeMapper.mapToGson(entry.getValue()));
            }
            return result;
        }
        throw new IllegalArgumentException("unknown element type: " + String.valueOf(jsonElement));
    }
}

