/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson;

import java.lang.reflect.Type;
import java.util.Objects;
import name.martingeisse.grumpyjson.JsonRegistries;
import name.martingeisse.grumpyjson.TypeToken;
import name.martingeisse.grumpyjson.builtin.BooleanConverter;
import name.martingeisse.grumpyjson.builtin.IntegerConverter;
import name.martingeisse.grumpyjson.builtin.JsonElementConverter;
import name.martingeisse.grumpyjson.builtin.ListConverter;
import name.martingeisse.grumpyjson.builtin.LongConverter;
import name.martingeisse.grumpyjson.builtin.MapConverter;
import name.martingeisse.grumpyjson.builtin.StringConverter;
import name.martingeisse.grumpyjson.builtin.helper_types.FieldMustBeNullConverter;
import name.martingeisse.grumpyjson.builtin.helper_types.NullableFieldConverter;
import name.martingeisse.grumpyjson.builtin.helper_types.OptionalFieldConverter;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializationException;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializer;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializerRegistry;
import name.martingeisse.grumpyjson.json_model.JsonElement;
import name.martingeisse.grumpyjson.serialize.JsonSerializationException;
import name.martingeisse.grumpyjson.serialize.JsonSerializer;
import name.martingeisse.grumpyjson.serialize.JsonSerializerRegistry;

public class StructuralJsonEngine {
    private final JsonRegistries registries = JsonRegistries.createDefault();

    public StructuralJsonEngine() {
        this.registerDualConverter(new BooleanConverter());
        this.registerDualConverter(new IntegerConverter());
        this.registerDualConverter(new LongConverter());
        this.registerDualConverter(new StringConverter());
        this.registerDualConverter(new ListConverter(this.registries));
        this.registerDualConverter(new MapConverter(this.registries));
        this.registerDualConverter(new FieldMustBeNullConverter());
        this.registerDualConverter(new NullableFieldConverter(this.registries));
        this.registerDualConverter(new OptionalFieldConverter(this.registries));
        this.registerDualConverter(new JsonElementConverter());
    }

    public final void registerSerializer(JsonSerializer<?> serializer) {
        this.registries.registerSerializer(serializer);
    }

    public final void registerDeserializer(JsonDeserializer deserializer) {
        this.registries.registerDeserializer(deserializer);
    }

    public final <T extends JsonSerializer<?> & JsonDeserializer> void registerDualConverter(T converter) {
        this.registries.registerDualConverter(converter);
    }

    public final JsonRegistries getRegistries() {
        return this.registries;
    }

    public final JsonSerializerRegistry getSerializerRegistry() {
        return this.registries.serializerRegistry();
    }

    public final JsonDeserializerRegistry getDeserializerRegistry() {
        return this.registries.deserializerRegistry();
    }

    public void seal() {
        this.registries.seal();
    }

    public final boolean supportsClassForSerialization(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return this.registries.supportsClassForSerialization(clazz);
    }

    public final boolean supportsTypeForDeserialization(Type type) {
        Objects.requireNonNull(type, "type");
        return this.registries.supportsTypeForDeserialization(type);
    }

    public final <T> T deserialize(JsonElement source, Class<T> clazz) throws JsonDeserializationException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(clazz, "clazz");
        return clazz.cast(this.deserialize(source, (Type)clazz));
    }

    public final <T> T deserialize(JsonElement source, TypeToken<T> typeToken) throws JsonDeserializationException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(typeToken, "typeToken");
        return (T)this.deserialize(source, typeToken.getType());
    }

    public final Object deserialize(JsonElement source, Type type) throws JsonDeserializationException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(type, "type");
        return this.registries.deserialize(source, type);
    }

    public final JsonElement toJsonElement(Object value) throws JsonSerializationException {
        Objects.requireNonNull(value, "value");
        return this.registries.serialize(value);
    }
}

