/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.builtin;

import java.lang.reflect.Type;
import java.util.Objects;
import name.martingeisse.grumpyjson.builtin.IntegralNumberDeserializationUtil;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializationException;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializer;
import name.martingeisse.grumpyjson.json_model.JsonElement;
import name.martingeisse.grumpyjson.json_model.JsonNumber;
import name.martingeisse.grumpyjson.serialize.JsonSerializationException;
import name.martingeisse.grumpyjson.serialize.JsonSerializer;

public final class IntegerConverter
implements JsonSerializer<Integer>,
JsonDeserializer {
    @Override
    public boolean supportsTypeForDeserialization(Type type) {
        Objects.requireNonNull(type, "type");
        return type.equals(Integer.TYPE) || type.equals(Integer.class);
    }

    @Override
    public Integer deserialize(JsonElement json, Type type) throws JsonDeserializationException {
        Objects.requireNonNull(json, "json");
        Objects.requireNonNull(type, "type");
        long longValue = IntegralNumberDeserializationUtil.deserialize(json.deserializerExpectsNumber());
        int intValue = (int)longValue;
        IntegralNumberDeserializationUtil.verifyBounds(longValue, intValue);
        return intValue;
    }

    @Override
    public boolean supportsClassForSerialization(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return clazz.equals(Integer.TYPE) || clazz.equals(Integer.class);
    }

    @Override
    public JsonElement serialize(Integer value) throws JsonSerializationException {
        Objects.requireNonNull(value, "value");
        return JsonNumber.of(value);
    }
}

