/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.builtin;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import name.martingeisse.grumpyjson.FieldErrorNode;
import name.martingeisse.grumpyjson.JsonProviders;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializationException;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializer;
import name.martingeisse.grumpyjson.json_model.JsonArray;
import name.martingeisse.grumpyjson.json_model.JsonElement;
import name.martingeisse.grumpyjson.registry.NotRegisteredException;
import name.martingeisse.grumpyjson.serialize.JsonSerializationException;
import name.martingeisse.grumpyjson.serialize.JsonSerializer;
import name.martingeisse.grumpyjson.util.TypeUtil;

public final class ListConverter
implements JsonSerializer<List<?>>,
JsonDeserializer {
    private final JsonProviders providers;

    public ListConverter(JsonProviders providers) {
        Objects.requireNonNull(providers, "providers");
        this.providers = providers;
    }

    @Override
    public boolean supportsTypeForDeserialization(Type type) {
        Objects.requireNonNull(type, "type");
        return TypeUtil.isSingleParameterizedType(type, List.class) != null;
    }

    @Override
    public List<?> deserialize(JsonElement json, Type type) throws JsonDeserializationException {
        JsonDeserializer elementDeserializer;
        Objects.requireNonNull(json, "json");
        Objects.requireNonNull(type, "type");
        List<JsonElement> jsonChildren = json.deserializerExpectsArray();
        Type elementType = TypeUtil.expectSingleParameterizedType(type, List.class);
        try {
            elementDeserializer = this.providers.getDeserializer(elementType);
        }
        catch (NotRegisteredException e) {
            throw new JsonDeserializationException(e.getMessage());
        }
        ArrayList<Object> resultChildren = new ArrayList<Object>();
        FieldErrorNode errorNode = null;
        for (int i = 0; i < jsonChildren.size(); ++i) {
            try {
                resultChildren.add(elementDeserializer.deserialize(jsonChildren.get(i), elementType));
                continue;
            }
            catch (JsonDeserializationException e) {
                errorNode = e.getFieldErrorNode().in(Integer.toString(i)).and(errorNode);
                continue;
            }
            catch (Exception e) {
                errorNode = FieldErrorNode.create(e).in(Integer.toString(i)).and(errorNode);
            }
        }
        if (errorNode != null) {
            throw new JsonDeserializationException(errorNode);
        }
        return List.copyOf(resultChildren);
    }

    @Override
    public boolean supportsClassForSerialization(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return List.class.isAssignableFrom(clazz);
    }

    @Override
    public JsonElement serialize(List<?> value) throws JsonSerializationException {
        Objects.requireNonNull(value, "value");
        ArrayList<JsonElement> jsonChildren = new ArrayList<JsonElement>();
        FieldErrorNode errorNode = null;
        for (int i = 0; i < value.size(); ++i) {
            try {
                jsonChildren.add(this.providers.serialize(value.get(i)));
                continue;
            }
            catch (JsonSerializationException e) {
                errorNode = e.getFieldErrorNode().in(Integer.toString(i)).and(errorNode);
                continue;
            }
            catch (Exception e) {
                errorNode = FieldErrorNode.create(e).in(Integer.toString(i)).and(errorNode);
            }
        }
        if (errorNode != null) {
            throw new JsonSerializationException(errorNode);
        }
        return JsonArray.of(jsonChildren);
    }
}

