/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.builtin;

import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializationException;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializer;
import name.martingeisse.grumpyjson.json_model.JsonElement;
import name.martingeisse.grumpyjson.json_model.JsonString;
import name.martingeisse.grumpyjson.serialize.JsonSerializationException;
import name.martingeisse.grumpyjson.serialize.JsonSerializer;

public final class LocalDateTimeConverter
implements JsonSerializer<LocalDateTime>,
JsonDeserializer {
    @Override
    public boolean supportsTypeForDeserialization(Type type) {
        Objects.requireNonNull(type, "type");
        return type.equals(LocalDateTime.class);
    }

    @Override
    public LocalDateTime deserialize(JsonElement json, Type type) throws JsonDeserializationException {
        Objects.requireNonNull(json, "json");
        Objects.requireNonNull(type, "type");
        String text = json.deserializerExpectsString();
        try {
            return LocalDateTime.parse(text);
        }
        catch (DateTimeParseException e) {
            throw new JsonDeserializationException(e.getMessage());
        }
    }

    @Override
    public boolean supportsClassForSerialization(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return clazz.equals(LocalDateTime.class);
    }

    @Override
    public JsonElement serialize(LocalDateTime value) throws JsonSerializationException {
        Objects.requireNonNull(value, "value");
        return JsonString.of(value.toString());
    }
}

