/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.builtin;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import name.martingeisse.grumpyjson.FieldErrorNode;
import name.martingeisse.grumpyjson.JsonProviders;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializationException;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializer;
import name.martingeisse.grumpyjson.json_model.JsonElement;
import name.martingeisse.grumpyjson.json_model.JsonObject;
import name.martingeisse.grumpyjson.json_model.JsonString;
import name.martingeisse.grumpyjson.registry.NotRegisteredException;
import name.martingeisse.grumpyjson.serialize.JsonSerializationException;
import name.martingeisse.grumpyjson.serialize.JsonSerializer;
import name.martingeisse.grumpyjson.util.TypeUtil;

public final class MapConverter
implements JsonSerializer<Map<?, ?>>,
JsonDeserializer {
    private final JsonProviders providers;

    public MapConverter(JsonProviders providers) {
        this.providers = providers;
    }

    @Override
    public boolean supportsTypeForDeserialization(Type type) {
        Objects.requireNonNull(type, "type");
        return TypeUtil.isParameterizedType(type, Map.class, 2) != null;
    }

    private static String buildFromJsonFieldName(boolean isAtKey, String key) {
        return (isAtKey ? "key[" : "value[") + key + "]";
    }

    @Override
    public Map<?, ?> deserialize(JsonElement json, Type type) throws JsonDeserializationException {
        JsonDeserializer valueDeserializer;
        JsonDeserializer keyDeserializer;
        Objects.requireNonNull(json, "json");
        Objects.requireNonNull(type, "type");
        Map<String, JsonElement> jsonProperties = json.deserializerExpectsObject();
        Type[] keyAndValueTypes = TypeUtil.expectParameterizedType(type, List.class, 2);
        Type keyType = keyAndValueTypes[0];
        Type valueType = keyAndValueTypes[1];
        try {
            keyDeserializer = this.providers.getDeserializer(keyType);
            valueDeserializer = this.providers.getDeserializer(valueType);
        }
        catch (NotRegisteredException e) {
            throw new JsonDeserializationException(e.getMessage());
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        FieldErrorNode errorNode = null;
        for (Map.Entry<String, JsonElement> entry : jsonProperties.entrySet()) {
            String keyText = entry.getKey();
            boolean isAtKey = true;
            try {
                Object key = keyDeserializer.deserialize(JsonString.of(keyText), keyType);
                isAtKey = false;
                Object value = valueDeserializer.deserialize(entry.getValue(), valueType);
                result.put(key, value);
            }
            catch (JsonDeserializationException e) {
                errorNode = e.getFieldErrorNode().in(MapConverter.buildFromJsonFieldName(isAtKey, keyText)).and(errorNode);
            }
            catch (Exception e) {
                errorNode = FieldErrorNode.create(e).in(MapConverter.buildFromJsonFieldName(isAtKey, keyText)).and(errorNode);
            }
        }
        if (errorNode != null) {
            throw new JsonDeserializationException(errorNode);
        }
        return Map.copyOf(result);
    }

    @Override
    public boolean supportsClassForSerialization(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return Map.class.isAssignableFrom(clazz);
    }

    @Override
    public JsonElement serialize(Map<?, ?> map) throws JsonSerializationException {
        Objects.requireNonNull(map, "value");
        HashMap<String, JsonElement> jsonProperties = new HashMap<String, JsonElement>();
        FieldErrorNode errorNode = null;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            JsonElement keyJson;
            Object keyObject = entry.getKey();
            if (keyObject == null) {
                throw new JsonSerializationException("map contains null key");
            }
            try {
                keyJson = this.providers.serialize(keyObject);
            }
            catch (JsonSerializationException e) {
                errorNode = e.getFieldErrorNode().in("[" + String.valueOf(keyObject) + "]").and(errorNode);
                continue;
            }
            catch (Exception e) {
                errorNode = FieldErrorNode.create(e).in("[" + String.valueOf(keyObject) + "]").and(errorNode);
                continue;
            }
            if (!(keyJson instanceof JsonString)) {
                errorNode = FieldErrorNode.create("map key does not serialize to a JSON string").in("[" + String.valueOf(keyObject) + "]").and(errorNode);
                continue;
            }
            JsonString s = (JsonString)keyJson;
            String keyText = s.getValue();
            try {
                Object valueObject = entry.getValue();
                if (valueObject == null) {
                    throw new JsonSerializationException("map contains null value");
                }
                JsonElement valueJson = this.providers.serialize(valueObject);
                jsonProperties.put(keyText, valueJson);
            }
            catch (JsonSerializationException e) {
                errorNode = e.getFieldErrorNode().in(keyText).and(errorNode);
            }
            catch (Exception e) {
                errorNode = FieldErrorNode.create(e).in(keyText).and(errorNode);
            }
        }
        if (errorNode != null) {
            throw new JsonSerializationException(errorNode);
        }
        return JsonObject.of(jsonProperties);
    }
}

