/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.builtin.helper_types;

import java.lang.reflect.Type;
import java.util.Objects;
import name.martingeisse.grumpyjson.JsonProviders;
import name.martingeisse.grumpyjson.builtin.helper_types.NullableField;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializationException;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializer;
import name.martingeisse.grumpyjson.json_model.JsonElement;
import name.martingeisse.grumpyjson.json_model.JsonNull;
import name.martingeisse.grumpyjson.serialize.JsonSerializationException;
import name.martingeisse.grumpyjson.serialize.JsonSerializer;
import name.martingeisse.grumpyjson.util.TypeUtil;

public final class NullableFieldConverter
implements JsonSerializer<NullableField<?>>,
JsonDeserializer {
    private final JsonProviders providers;

    public NullableFieldConverter(JsonProviders providers) {
        Objects.requireNonNull(providers, "providers");
        this.providers = providers;
    }

    @Override
    public boolean supportsTypeForDeserialization(Type type) {
        Objects.requireNonNull(type, "type");
        return TypeUtil.isSingleParameterizedType(type, NullableField.class) != null;
    }

    @Override
    public NullableField<?> deserialize(JsonElement json, Type type) throws JsonDeserializationException {
        Objects.requireNonNull(json, "json");
        Objects.requireNonNull(type, "type");
        Type innerType = TypeUtil.expectSingleParameterizedType(type, NullableField.class);
        if (json instanceof JsonNull) {
            return NullableField.ofNull();
        }
        try {
            return NullableField.ofValue(this.providers.deserialize(json, innerType));
        }
        catch (JsonDeserializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonDeserializationException(e);
        }
    }

    @Override
    public boolean supportsClassForSerialization(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return clazz.equals(NullableField.class);
    }

    @Override
    public JsonElement serialize(NullableField<?> value) throws JsonSerializationException {
        Objects.requireNonNull(value, "value");
        if (value.isNull()) {
            return JsonNull.INSTANCE;
        }
        try {
            return this.providers.serialize(value.getValueOrNull());
        }
        catch (JsonSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JsonSerializationException(e);
        }
    }
}

