/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.builtin.record;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import name.martingeisse.grumpyjson.FieldErrorNode;
import name.martingeisse.grumpyjson.JsonProviders;
import name.martingeisse.grumpyjson.builtin.record.RecordInfo;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializationException;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializer;
import name.martingeisse.grumpyjson.json_model.JsonElement;
import name.martingeisse.grumpyjson.json_model.JsonObject;
import name.martingeisse.grumpyjson.serialize.JsonSerializationException;
import name.martingeisse.grumpyjson.serialize.JsonSerializer;

public final class RecordConverter<T>
implements JsonSerializer<T>,
JsonDeserializer {
    private final RecordInfo recordInfo;
    private final JsonProviders providers;
    private final Options options;

    public RecordConverter(Class<T> clazz, JsonProviders providers) {
        this(clazz, providers, new Options(false));
    }

    public RecordConverter(Class<T> clazz, JsonProviders providers, Options options) {
        Objects.requireNonNull(clazz, "clazz");
        Objects.requireNonNull(providers, "providers");
        Objects.requireNonNull(options, "options");
        this.recordInfo = new RecordInfo(clazz);
        this.providers = providers;
        this.options = options;
    }

    @Override
    public boolean supportsTypeForDeserialization(Type type) {
        ParameterizedType p;
        Objects.requireNonNull(type, "type");
        if (type instanceof Class) {
            return type.equals(this.recordInfo.getRecordClass());
        }
        if (type instanceof ParameterizedType && (p = (ParameterizedType)type).getRawType() instanceof Class) {
            return p.getRawType().equals(this.recordInfo.getRecordClass());
        }
        return false;
    }

    public T deserialize(JsonElement json, Type recordType) throws JsonDeserializationException {
        Objects.requireNonNull(json, "json");
        Objects.requireNonNull(recordType, "recordType");
        Map<String, JsonElement> jsonProperties = json.deserializerExpectsObject();
        List<RecordInfo.ComponentInfo> componentInfos = this.recordInfo.getComponentInfos();
        int numberOfPresentKnownProperties = 0;
        Object[] fieldValues = new Object[componentInfos.size()];
        FieldErrorNode errorNode = null;
        for (int i = 0; i < componentInfos.size(); ++i) {
            RecordInfo.ComponentInfo componentInfo = componentInfos.get(i);
            String name = componentInfo.getName();
            JsonElement propertyJson = jsonProperties.get(name);
            if (propertyJson != null) {
                ++numberOfPresentKnownProperties;
            }
            try {
                Type concreteFieldType = componentInfo.getConcreteType(recordType);
                JsonDeserializer deserializer = this.providers.getDeserializer(concreteFieldType);
                if (propertyJson == null) {
                    fieldValues[i] = deserializer.deserializeAbsent(concreteFieldType);
                    continue;
                }
                fieldValues[i] = deserializer.deserialize(propertyJson, concreteFieldType);
                continue;
            }
            catch (JsonDeserializationException e) {
                errorNode = e.getFieldErrorNode().in(name).and(errorNode);
                continue;
            }
            catch (Exception e) {
                errorNode = FieldErrorNode.create(e).in(name).and(errorNode);
            }
        }
        if (!this.options.ignoreUnknownProperties() && numberOfPresentKnownProperties != jsonProperties.size()) {
            HashSet<String> propertyNames = new HashSet<String>(jsonProperties.keySet());
            for (RecordInfo.ComponentInfo componentInfo : componentInfos) {
                propertyNames.remove(componentInfo.getName());
            }
            for (String unexpectedProperty : propertyNames) {
                errorNode = FieldErrorNode.create("unexpected property").in(unexpectedProperty).and(errorNode);
            }
        }
        if (errorNode != null) {
            throw new JsonDeserializationException(errorNode);
        }
        try {
            return (T)this.recordInfo.invokeConstructor(fieldValues);
        }
        catch (InvocationTargetException e) {
            throw new JsonDeserializationException(FieldErrorNode.create(e.getTargetException().getMessage()));
        }
        catch (Exception e) {
            throw new JsonDeserializationException(FieldErrorNode.create(e));
        }
    }

    @Override
    public boolean supportsClassForSerialization(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return clazz.equals(this.recordInfo.getRecordClass());
    }

    @Override
    public JsonElement serialize(T record) {
        Objects.requireNonNull(record, "value");
        HashMap<String, JsonElement> jsonProperties = new HashMap<String, JsonElement>();
        FieldErrorNode errorNode = null;
        for (RecordInfo.ComponentInfo componentInfo : this.recordInfo.getComponentInfos()) {
            String name = componentInfo.getName();
            try {
                Object value = componentInfo.invokeGetter(record);
                if (value == null) {
                    throw new JsonSerializationException("field is null");
                }
                Optional<JsonElement> optionalJson = this.providers.serializeOptional(value);
                optionalJson.ifPresent(jsonElement -> jsonProperties.put(name, (JsonElement)jsonElement));
            }
            catch (JsonSerializationException e) {
                errorNode = e.getFieldErrorNode().in(name).and(errorNode);
            }
            catch (Exception e) {
                errorNode = FieldErrorNode.create(e).in(name).and(errorNode);
            }
        }
        if (errorNode != null) {
            throw new JsonSerializationException(errorNode);
        }
        return JsonObject.of(jsonProperties);
    }

    public record Options(boolean ignoreUnknownProperties) {
    }
}

