/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.json_model;

import java.util.List;
import name.martingeisse.grumpyjson.json_model.JsonElement;

public abstract class JsonArray
extends JsonElement {
    public static JsonArray of(List<JsonElement> elements) {
        return new VariableLenthArray(List.copyOf(elements));
    }

    public static JsonArray of(JsonElement ... elements) {
        return new VariableLenthArray(List.of(elements));
    }

    private JsonArray() {
    }

    public abstract List<JsonElement> getAsList();

    @Override
    public final List<JsonElement> deserializerExpectsArray() {
        return this.getAsList();
    }

    public boolean equals(Object obj) {
        JsonArray a;
        return obj instanceof JsonArray && (a = (JsonArray)obj).getAsList().equals(this.getAsList());
    }

    public int hashCode() {
        return this.getAsList().hashCode();
    }

    public String toString() {
        return "JSON:" + String.valueOf(this.getAsList());
    }

    private static final class VariableLenthArray
    extends JsonArray {
        private final List<JsonElement> elements;

        VariableLenthArray(List<JsonElement> elements) {
            this.elements = elements;
        }

        @Override
        public List<JsonElement> getAsList() {
            return this.elements;
        }
    }
}

