/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.json_model;

import name.martingeisse.grumpyjson.json_model.JsonElement;

public final class JsonBoolean
extends JsonElement {
    public static final JsonBoolean TRUE = new JsonBoolean(true);
    public static final JsonBoolean FALSE = new JsonBoolean(false);
    private final boolean value;

    public static JsonBoolean of(boolean value) {
        return value ? TRUE : FALSE;
    }

    private JsonBoolean(boolean value) {
        this.value = value;
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public boolean deserializerExpectsBoolean() {
        return this.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof JsonBoolean)) return false;
        JsonBoolean b = (JsonBoolean)obj;
        if (b.value != this.value) return false;
        return true;
    }

    public int hashCode() {
        return Boolean.hashCode(this.value);
    }

    public String toString() {
        return this.value ? "JSON:true" : "JSON:false";
    }
}

