/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.json_model;

import java.math.BigDecimal;
import java.math.BigInteger;
import name.martingeisse.grumpyjson.json_model.JsonElement;

public final class JsonNumber
extends JsonElement {
    private final Number value;

    public static JsonNumber of(Number value) {
        return new JsonNumber(value);
    }

    private JsonNumber(Number value) {
        this.value = value;
    }

    public Number getValue() {
        return this.value;
    }

    @Override
    public Number deserializerExpectsNumber() {
        return this.value;
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof JsonNumber)) {
            return false;
        }
        JsonNumber otherJsonNumber = (JsonNumber)otherObject;
        Number otherNumber = otherJsonNumber.value;
        if (this.value.longValue() != otherNumber.longValue() || this.value.doubleValue() != otherNumber.doubleValue()) {
            return false;
        }
        Number number = this.value;
        if (number instanceof BigDecimal) {
            BigDecimal d = (BigDecimal)number;
            return JsonNumber.detailedEquals(d, otherNumber);
        }
        if (otherNumber instanceof BigDecimal) {
            BigDecimal d = (BigDecimal)otherNumber;
            return JsonNumber.detailedEquals(d, this.value);
        }
        number = this.value;
        if (number instanceof BigInteger) {
            BigInteger i = (BigInteger)number;
            return JsonNumber.detailedEquals(new BigDecimal(i), otherNumber);
        }
        if (otherNumber instanceof BigInteger) {
            BigInteger i = (BigInteger)otherNumber;
            return JsonNumber.detailedEquals(new BigDecimal(i), this.value);
        }
        return true;
    }

    private static boolean detailedEquals(BigDecimal x, Number y) {
        if (y instanceof BigDecimal) {
            BigDecimal yd = (BigDecimal)y;
            return x.compareTo(yd) == 0;
        }
        if (y instanceof BigInteger) {
            BigInteger yi = (BigInteger)y;
            return x.compareTo(new BigDecimal(yi)) == 0;
        }
        if (y instanceof Long) {
            Long yi = (Long)y;
            return x.compareTo(BigDecimal.valueOf(yi)) == 0;
        }
        return x.compareTo(BigDecimal.valueOf(y.doubleValue())) == 0;
    }

    public int hashCode() {
        return Double.hashCode(this.value.doubleValue());
    }

    public String toString() {
        return "JSON:" + String.valueOf(this.value);
    }
}

