/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.json_model;

import java.util.Map;
import name.martingeisse.grumpyjson.json_model.JsonElement;

public abstract class JsonObject
extends JsonElement {
    public static JsonObject of(Map<String, JsonElement> properties) {
        return new VariableSizeObject(Map.copyOf(properties));
    }

    public static JsonObject of() {
        return new VariableSizeObject(Map.of());
    }

    public static JsonObject of(String key1, JsonElement value1) {
        return new VariableSizeObject(Map.of(key1, value1));
    }

    public static JsonObject of(String key1, JsonElement value1, String key2, JsonElement value2) {
        return new VariableSizeObject(Map.of(key1, value1, key2, value2));
    }

    public static JsonObject of(String key1, JsonElement value1, String key2, JsonElement value2, String key3, JsonElement value3) {
        return new VariableSizeObject(Map.of(key1, value1, key2, value2, key3, value3));
    }

    private JsonObject() {
    }

    public abstract Map<String, JsonElement> getAsMap();

    @Override
    public final Map<String, JsonElement> deserializerExpectsObject() {
        return this.getAsMap();
    }

    public boolean equals(Object obj) {
        JsonObject o;
        return obj instanceof JsonObject && (o = (JsonObject)obj).getAsMap().equals(this.getAsMap());
    }

    public int hashCode() {
        return this.getAsMap().hashCode();
    }

    public String toString() {
        return "JSON:" + String.valueOf(this.getAsMap());
    }

    private static final class VariableSizeObject
    extends JsonObject {
        private final Map<String, JsonElement> properties;

        VariableSizeObject(Map<String, JsonElement> properties) {
            this.properties = properties;
        }

        @Override
        public Map<String, JsonElement> getAsMap() {
            return this.properties;
        }
    }
}

