/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.accessories;

import io.github.hapjava.accessories.HomekitAccessory;
import io.github.hapjava.characteristics.HomekitCharacteristicChangeCallback;
import io.github.hapjava.characteristics.impl.thermostat.CurrentHeatingCoolingStateEnum;
import io.github.hapjava.characteristics.impl.thermostat.TargetHeatingCoolingStateEnum;
import io.github.hapjava.characteristics.impl.thermostat.TemperatureDisplayUnitEnum;
import io.github.hapjava.services.Service;
import io.github.hapjava.services.impl.ThermostatService;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;

public interface ThermostatAccessory
extends HomekitAccessory {
    public CompletableFuture<Double> getCurrentTemperature();

    default public double getMinCurrentTemperature() {
        return 0.0;
    }

    default public double getMaxCurrentTemperature() {
        return 100.0;
    }

    default public double getMinStepCurrentTemperature() {
        return 0.1;
    }

    public CompletableFuture<Double> getTargetTemperature();

    public void setTargetTemperature(Double var1) throws Exception;

    default public double getMinTargetTemperature() {
        return 10.0;
    }

    default public double getMaxTargetTemperature() {
        return 38.0;
    }

    default public double getMinStepTargetTemperature() {
        return 0.1;
    }

    public CompletableFuture<CurrentHeatingCoolingStateEnum> getCurrentState();

    public void setTargetState(TargetHeatingCoolingStateEnum var1) throws Exception;

    public CompletableFuture<TargetHeatingCoolingStateEnum> getTargetState();

    public CompletableFuture<TemperatureDisplayUnitEnum> getTemperatureDisplayUnit();

    public void setTemperatureDisplayUnit(TemperatureDisplayUnitEnum var1) throws Exception;

    public void subscribeTargetState(HomekitCharacteristicChangeCallback var1);

    public void subscribeTargetTemperature(HomekitCharacteristicChangeCallback var1);

    public void subscribeTemperatureDisplayUnit(HomekitCharacteristicChangeCallback var1);

    public void subscribeCurrentTemperature(HomekitCharacteristicChangeCallback var1);

    public void subscribeCurrentState(HomekitCharacteristicChangeCallback var1);

    public void unsubscribeCurrentState();

    public void unsubscribeTargetState();

    public void unsubscribeCurrentTemperature();

    public void unsubscribeTemperatureDisplayUnit();

    public void unsubscribeTargetTemperature();

    default public CurrentHeatingCoolingStateEnum[] getCurrentHeatingCoolingStateValidValues() {
        return CurrentHeatingCoolingStateEnum.values();
    }

    default public TargetHeatingCoolingStateEnum[] getTargetHeatingCoolingStateValidValues() {
        return TargetHeatingCoolingStateEnum.values();
    }

    @Override
    default public Collection<Service> getServices() {
        return Collections.singleton(new ThermostatService(this));
    }
}

