/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.characteristics.impl.base;

import io.github.hapjava.characteristics.CharacteristicEnum;
import io.github.hapjava.characteristics.ExceptionalConsumer;
import io.github.hapjava.characteristics.HomekitCharacteristicChangeCallback;
import io.github.hapjava.characteristics.impl.base.BaseCharacteristic;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public abstract class EnumCharacteristic<T extends CharacteristicEnum>
extends BaseCharacteristic<Integer> {
    private final T[] validValues;
    Optional<Supplier<CompletableFuture<T>>> getter;
    protected Optional<ExceptionalConsumer<T>> setter;

    public EnumCharacteristic(String type, String description, T[] validValues, Optional<Supplier<CompletableFuture<T>>> getter, Optional<ExceptionalConsumer<T>> setter, Optional<Consumer<HomekitCharacteristicChangeCallback>> subscriber, Optional<Runnable> unsubscriber) {
        super(type, "int", description, getter.isPresent(), setter.isPresent(), subscriber, unsubscriber);
        this.getter = getter;
        this.setter = setter;
        this.validValues = validValues;
    }

    @Override
    protected CompletableFuture<JsonObjectBuilder> makeBuilder(int iid) {
        JsonArrayBuilder validValuesBuilder = Json.createArrayBuilder();
        if (this.validValues != null && this.validValues.length != 0) {
            Arrays.stream(this.validValues).forEach(value -> validValuesBuilder.add(value.getCode()));
        }
        return super.makeBuilder(iid).thenApply(builder -> builder.add("valid-values", validValuesBuilder));
    }

    @Override
    protected Integer convert(JsonValue jsonValue) {
        if (jsonValue instanceof JsonNumber) {
            return ((JsonNumber)jsonValue).intValue();
        }
        if (jsonValue == JsonObject.TRUE) {
            return 1;
        }
        if (jsonValue == JsonObject.FALSE) {
            return 0;
        }
        throw new IndexOutOfBoundsException("Cannot convert " + jsonValue.getClass() + " to int");
    }

    @Override
    protected CompletableFuture<Integer> getValue() {
        if (!this.getter.isPresent()) {
            return null;
        }
        return this.getter.get().get().thenApply(CharacteristicEnum::getCode);
    }

    @Override
    protected void setValue(Integer value) throws Exception {
        if (!this.setter.isPresent()) {
            return;
        }
        if (this.validValues != null && value != null) {
            for (T valid : this.validValues) {
                if (valid.getCode() != value.intValue()) continue;
                this.setter.get().accept(valid);
                return;
            }
        }
    }

    @Override
    public Integer getDefault() {
        if (this.validValues != null && this.validValues.length > 0) {
            return this.validValues[0].getCode();
        }
        return 0;
    }
}

