/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.characteristics.impl.base;

import io.github.hapjava.characteristics.ExceptionalConsumer;
import io.github.hapjava.characteristics.HomekitCharacteristicChangeCallback;
import io.github.hapjava.characteristics.impl.base.BaseCharacteristic;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.json.JsonNumber;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FloatCharacteristic
extends BaseCharacteristic<Double> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FloatCharacteristic.class);
    private final double minValue;
    private final double maxValue;
    private final double minStep;
    private final String unit;
    private final Optional<Supplier<CompletableFuture<Double>>> getter;
    private final Optional<ExceptionalConsumer<Double>> setter;

    public FloatCharacteristic(String type, String description, double minValue, double maxValue, double minStep, String unit, Optional<Supplier<CompletableFuture<Double>>> getter, Optional<ExceptionalConsumer<Double>> setter, Optional<Consumer<HomekitCharacteristicChangeCallback>> subscriber, Optional<Runnable> unsubscriber) {
        super(type, "float", description, getter.isPresent(), setter.isPresent(), subscriber, unsubscriber);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.unit = unit;
        this.getter = getter;
        this.setter = setter;
        this.minStep = minStep;
    }

    @Override
    protected CompletableFuture<JsonObjectBuilder> makeBuilder(int iid) {
        return super.makeBuilder(iid).thenApply(builder -> builder.add("minValue", this.minValue).add("maxValue", this.maxValue).add("minStep", this.minStep).add("unit", this.unit));
    }

    @Override
    protected Double convert(JsonValue jsonValue) {
        return ((JsonNumber)jsonValue).doubleValue();
    }

    @Override
    protected final CompletableFuture<Double> getValue() {
        if (!this.getter.isPresent()) {
            return null;
        }
        double rounder = 1.0 / this.minStep;
        return ((CompletableFuture)this.getter.get().get().thenApply(d -> d == null ? null : Double.valueOf((double)Math.round(d * rounder) / rounder))).thenApply(d -> {
            if (d != null) {
                if (d < this.minValue) {
                    LOGGER.warn("Detected value out of range " + d + ". Returning min value instead. Characteristic " + this);
                    return this.minValue;
                }
                if (d > this.maxValue) {
                    LOGGER.warn("Detected value out of range " + d + ". Returning max value instead. Characteristic " + this);
                    return this.maxValue;
                }
                return d;
            }
            return null;
        });
    }

    @Override
    protected void setValue(Double value) throws Exception {
        if (this.setter.isPresent()) {
            this.setter.get().accept(value);
        }
    }

    @Override
    public Double getDefault() {
        return this.minValue;
    }
}

