/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.characteristics.impl.base;

import io.github.hapjava.characteristics.HomekitCharacteristicChangeCallback;
import io.github.hapjava.characteristics.impl.base.BaseCharacteristic;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;

public class StaticStringCharacteristic
extends BaseCharacteristic<String> {
    private static final int MAX_LEN = 255;
    private final Optional<Supplier<CompletableFuture<String>>> getter;

    public StaticStringCharacteristic(String type, String description, Optional<Supplier<CompletableFuture<String>>> getter, Optional<Consumer<HomekitCharacteristicChangeCallback>> subscriber, Optional<Runnable> unsubscriber) {
        super(type, "string", description, getter.isPresent(), false, subscriber, unsubscriber);
        this.getter = getter;
    }

    @Override
    protected CompletableFuture<JsonObjectBuilder> makeBuilder(int iid) {
        return super.makeBuilder(iid).thenApply(builder -> builder.add("maxLen", 255));
    }

    @Override
    public String convert(JsonValue jsonValue) {
        return ((JsonString)jsonValue).getString();
    }

    @Override
    public void setValue(String value) throws Exception {
        throw new Exception("Cannot modify static strings");
    }

    @Override
    protected CompletableFuture<String> getValue() {
        return this.getter.map(stringGetter -> (CompletableFuture)stringGetter.get()).orElse(null);
    }

    @Override
    public String getDefault() {
        return "Unknown";
    }
}

