/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.characteristics.impl.base;

import io.github.hapjava.characteristics.ExceptionalConsumer;
import io.github.hapjava.characteristics.HomekitCharacteristicChangeCallback;
import io.github.hapjava.characteristics.impl.base.BaseCharacteristic;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;

public class StringCharacteristic
extends BaseCharacteristic<String> {
    private final Optional<Supplier<CompletableFuture<String>>> getter;
    private final Optional<ExceptionalConsumer<String>> setter;

    public StringCharacteristic(String type, String description, Optional<Supplier<CompletableFuture<String>>> getter, Optional<ExceptionalConsumer<String>> setter, Optional<Consumer<HomekitCharacteristicChangeCallback>> subscriber, Optional<Runnable> unsubscriber) {
        super(type, "string", description, getter.isPresent(), setter.isPresent(), subscriber, unsubscriber);
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    protected CompletableFuture<JsonObjectBuilder> makeBuilder(int iid) {
        return super.makeBuilder(iid);
    }

    @Override
    public String convert(JsonValue jsonValue) {
        return ((JsonString)jsonValue).getString();
    }

    @Override
    public void setValue(String value) throws Exception {
        if (this.setter.isPresent()) {
            this.setter.get().accept(value);
        }
    }

    @Override
    protected CompletableFuture<String> getValue() {
        return this.getter.map(stringGetter -> (CompletableFuture)stringGetter.get()).orElse(null);
    }

    @Override
    public String getDefault() {
        return "Unknown";
    }
}

