/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.characteristics.impl.common;

import io.github.hapjava.characteristics.CharacteristicEnum;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum ProgramModeEnum implements CharacteristicEnum
{
    NO_SCHEDULED(0),
    SCHEDULED(1),
    SCHEDULED_MANUAL(2);

    private static final Map<Integer, ProgramModeEnum> reverse;
    private final int code;

    public static ProgramModeEnum fromCode(Integer code) {
        return reverse.get(code);
    }

    private ProgramModeEnum(int code) {
        this.code = code;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    static {
        reverse = Arrays.stream(ProgramModeEnum.values()).collect(Collectors.toMap(ProgramModeEnum::getCode, t -> t));
    }
}

