/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.characteristics.impl.television;

import io.github.hapjava.characteristics.CharacteristicEnum;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum PictureModeEnum implements CharacteristicEnum
{
    OTHER(0),
    STANDARD(1),
    CALIBRATED(2),
    CALIBRATED_DARK(3),
    VIVID(4),
    GAME(5),
    COMPUTER(6),
    CUSTOM(7);

    private static final Map<Integer, PictureModeEnum> reverse;
    private final int code;

    public static PictureModeEnum fromCode(Integer code) {
        return reverse.get(code);
    }

    private PictureModeEnum(int code) {
        this.code = code;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    static {
        reverse = Arrays.stream(PictureModeEnum.values()).collect(Collectors.toMap(PictureModeEnum::getCode, t -> t));
    }
}

