/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl.connections;

import io.github.hapjava.server.HomekitAuthInfo;
import io.github.hapjava.server.impl.HomekitRegistry;
import io.github.hapjava.server.impl.connections.HttpSession;
import io.github.hapjava.server.impl.connections.LengthPrefixedByteArrayProcessor;
import io.github.hapjava.server.impl.connections.SubscriptionManager;
import io.github.hapjava.server.impl.crypto.ChachaDecoder;
import io.github.hapjava.server.impl.crypto.ChachaEncoder;
import io.github.hapjava.server.impl.http.HomekitClientConnection;
import io.github.hapjava.server.impl.http.HttpRequest;
import io.github.hapjava.server.impl.http.HttpResponse;
import io.github.hapjava.server.impl.jmdns.JmdnsHomekitAdvertiser;
import io.github.hapjava.server.impl.pairing.UpgradeResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.function.Consumer;
import org.bouncycastle.util.Pack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectionImpl
implements HomekitClientConnection {
    private final HttpSession httpSession;
    private LengthPrefixedByteArrayProcessor binaryProcessor;
    private int inboundBinaryMessageCount = 0;
    private int outboundBinaryMessageCount = 0;
    private byte[] readKey;
    private byte[] writeKey;
    private boolean isUpgraded = false;
    private final Consumer<HttpResponse> outOfBandMessageCallback;
    private final SubscriptionManager subscriptions;
    private static final Logger LOGGER = LoggerFactory.getLogger(HomekitClientConnection.class);

    public ConnectionImpl(HomekitAuthInfo authInfo, HomekitRegistry registry, Consumer<HttpResponse> outOfBandMessageCallback, SubscriptionManager subscriptions, JmdnsHomekitAdvertiser advertiser) {
        this.httpSession = new HttpSession(authInfo, registry, subscriptions, this, advertiser);
        this.outOfBandMessageCallback = outOfBandMessageCallback;
        this.subscriptions = subscriptions;
    }

    @Override
    public synchronized HttpResponse handleRequest(HttpRequest request) throws IOException {
        return this.doHandleRequest(request);
    }

    private HttpResponse doHandleRequest(HttpRequest request) throws IOException {
        HttpResponse response;
        HttpResponse httpResponse = response = this.isUpgraded ? this.httpSession.handleAuthenticatedRequest(request) : this.httpSession.handleRequest(request);
        if (response instanceof UpgradeResponse) {
            this.isUpgraded = true;
            this.readKey = ((UpgradeResponse)response).getReadKey().array();
            this.writeKey = ((UpgradeResponse)response).getWriteKey().array();
        }
        LOGGER.trace(response.getStatusCode() + " " + request.getUri());
        return response;
    }

    @Override
    public byte[] decryptRequest(byte[] ciphertext) {
        byte[] byArray;
        Collection<byte[]> res;
        if (!this.isUpgraded) {
            throw new RuntimeException("Cannot handle binary before connection is upgraded");
        }
        if (this.binaryProcessor == null) {
            this.binaryProcessor = new LengthPrefixedByteArrayProcessor();
        }
        if ((res = this.binaryProcessor.handle(ciphertext)).isEmpty()) {
            return new byte[0];
        }
        ByteArrayOutputStream decrypted = new ByteArrayOutputStream();
        try {
            res.stream().map(msg -> this.decrypt((byte[])msg)).forEach(bytes -> {
                try {
                    decrypted.write((byte[])bytes);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            byArray = decrypted.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    decrypted.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        decrypted.close();
        return byArray;
    }

    @Override
    public byte[] encryptResponse(byte[] response) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            short length;
            for (int offset = 0; offset < response.length; offset += length) {
                byte[] plaintext;
                length = (short)Math.min(response.length - offset, 1024);
                byte[] lengthBytes = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(length).array();
                baos.write(lengthBytes);
                byte[] nonce = Pack.longToLittleEndian((long)this.outboundBinaryMessageCount++);
                if (response.length == length) {
                    plaintext = response;
                } else {
                    plaintext = new byte[length];
                    System.arraycopy(response, offset, plaintext, 0, length);
                }
                baos.write(new ChachaEncoder(this.writeKey, nonce).encodeCiphertext(plaintext, lengthBytes));
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    private byte[] decrypt(byte[] msg) {
        byte[] mac = new byte[16];
        byte[] ciphertext = new byte[msg.length - 16];
        System.arraycopy(msg, 0, ciphertext, 0, msg.length - 16);
        System.arraycopy(msg, msg.length - 16, mac, 0, 16);
        byte[] additionalData = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort((short)(msg.length - 16)).array();
        try {
            byte[] nonce = Pack.longToLittleEndian((long)this.inboundBinaryMessageCount++);
            return new ChachaDecoder(this.readKey, nonce).decodeCiphertext(mac, additionalData, ciphertext);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.subscriptions.removeConnection(this);
    }

    @Override
    public void outOfBand(HttpResponse message) {
        this.outOfBandMessageCallback.accept(message);
    }
}

