/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl.connections;

import io.github.hapjava.characteristics.EventableCharacteristic;
import io.github.hapjava.server.impl.connections.PendingNotification;
import io.github.hapjava.server.impl.http.HomekitClientConnection;
import io.github.hapjava.server.impl.http.HttpResponse;
import io.github.hapjava.server.impl.json.EventController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionManager.class);
    private final ConcurrentMap<EventableCharacteristic, Set<HomekitClientConnection>> subscriptions = new ConcurrentHashMap<EventableCharacteristic, Set<HomekitClientConnection>>();
    private final ConcurrentMap<HomekitClientConnection, Set<EventableCharacteristic>> reverse = new ConcurrentHashMap<HomekitClientConnection, Set<EventableCharacteristic>>();
    private final ConcurrentMap<HomekitClientConnection, ArrayList<PendingNotification>> pendingNotifications = new ConcurrentHashMap<HomekitClientConnection, ArrayList<PendingNotification>>();
    private int nestedBatches = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addSubscription(int aid, int iid, EventableCharacteristic characteristic, HomekitClientConnection connection) {
        SubscriptionManager subscriptionManager = this;
        synchronized (subscriptionManager) {
            if (!this.subscriptions.containsKey(characteristic)) {
                this.subscriptions.putIfAbsent(characteristic, this.newSet());
            }
            ((Set)this.subscriptions.get(characteristic)).add(connection);
            if (((Set)this.subscriptions.get(characteristic)).size() == 1) {
                characteristic.subscribe(() -> this.publish(aid, iid, characteristic));
            }
            if (!this.reverse.containsKey(connection)) {
                this.reverse.putIfAbsent(connection, this.newSet());
            }
            ((Set)this.reverse.get(connection)).add(characteristic);
            LOGGER.trace("Added subscription to " + characteristic.getClass() + " for " + connection.hashCode());
        }
    }

    public synchronized void removeSubscription(EventableCharacteristic characteristic, HomekitClientConnection connection) {
        Set reverse;
        Set subscriptions = (Set)this.subscriptions.get(characteristic);
        if (subscriptions != null) {
            subscriptions.remove(connection);
            if (subscriptions.size() == 0) {
                characteristic.unsubscribe();
            }
        }
        if ((reverse = (Set)this.reverse.get(connection)) != null) {
            reverse.remove(characteristic);
        }
        LOGGER.trace("Removed subscription to " + characteristic.getClass() + " for " + connection.hashCode());
    }

    public synchronized void removeConnection(HomekitClientConnection connection) {
        Set characteristics = (Set)this.reverse.remove(connection);
        this.pendingNotifications.remove(connection);
        if (characteristics != null) {
            for (EventableCharacteristic characteristic : characteristics) {
                Set characteristicSubscriptions = (Set)this.subscriptions.get(characteristic);
                characteristicSubscriptions.remove(connection);
                if (!characteristicSubscriptions.isEmpty()) continue;
                LOGGER.trace("Unsubscribing from characteristic as all subscriptions are closed");
                characteristic.unsubscribe();
                this.subscriptions.remove(characteristic);
            }
        }
        LOGGER.trace("Removed connection {}", (Object)connection.hashCode());
    }

    private <T> Set<T> newSet() {
        return Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public synchronized void batchUpdate() {
        ++this.nestedBatches;
    }

    public synchronized void completeUpdateBatch() {
        if (--this.nestedBatches == 0 && !this.pendingNotifications.isEmpty()) {
            LOGGER.trace("Publishing batched changes");
            for (Map.Entry entry : this.pendingNotifications.entrySet()) {
                try {
                    HttpResponse message = new EventController().getMessage((ArrayList)entry.getValue());
                    ((HomekitClientConnection)entry.getKey()).outOfBand(message);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to create new event message", (Throwable)e);
                }
            }
            this.pendingNotifications.clear();
        }
    }

    public synchronized void publish(int accessoryId, int iid, EventableCharacteristic changed) {
        Set subscribers = (Set)this.subscriptions.get(changed);
        if (subscribers == null || subscribers.isEmpty()) {
            LOGGER.debug("No subscribers to characteristic {} at accessory {} ", (Object)changed, (Object)accessoryId);
            return;
        }
        if (this.nestedBatches != 0) {
            LOGGER.trace("Batching change for accessory {} and characteristic {} " + accessoryId, (Object)iid);
            PendingNotification notification = new PendingNotification(accessoryId, iid, changed);
            for (HomekitClientConnection connection : subscribers) {
                if (!this.pendingNotifications.containsKey(connection)) {
                    this.pendingNotifications.put(connection, new ArrayList());
                }
                ((ArrayList)this.pendingNotifications.get(connection)).add(notification);
            }
            return;
        }
        try {
            HttpResponse message = new EventController().getMessage(accessoryId, iid, changed);
            LOGGER.trace("Publishing change for " + accessoryId);
            for (HomekitClientConnection connection : subscribers) {
                connection.outOfBand(message);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to create new event message", (Throwable)e);
        }
    }

    public void removeAll() {
        LOGGER.trace("Removing {} reverse connections from subscription manager", (Object)this.reverse.size());
        for (HomekitClientConnection connection : this.reverse.keySet()) {
            LOGGER.trace("Removing connection {}", (Object)connection.hashCode());
            this.removeConnection(connection);
        }
        LOGGER.trace("Subscription sizes are {} and {}", (Object)this.reverse.size(), (Object)this.subscriptions.size());
    }
}

