/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl.crypto;

import io.github.hapjava.server.impl.crypto.PolyKeyCreator;
import java.io.IOException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.ChaChaEngine;
import org.bouncycastle.crypto.generators.Poly1305KeyGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.util.Arrays;

public class ChachaDecoder {
    private final ChaChaEngine decryptCipher = new ChaChaEngine(20);

    public ChachaDecoder(byte[] key, byte[] nonce) throws IOException {
        this.decryptCipher.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(key), nonce));
    }

    public byte[] decodeCiphertext(byte[] receivedMAC, byte[] additionalData, byte[] ciphertext) throws IOException {
        KeyParameter macKey = this.initRecordMAC(this.decryptCipher);
        byte[] calculatedMAC = PolyKeyCreator.create(macKey, additionalData, ciphertext);
        if (!Arrays.constantTimeAreEqual((byte[])calculatedMAC, (byte[])receivedMAC)) {
            throw new TlsFatalAlert(20);
        }
        byte[] output = new byte[ciphertext.length];
        this.decryptCipher.processBytes(ciphertext, 0, ciphertext.length, output, 0);
        return output;
    }

    public byte[] decodeCiphertext(byte[] receivedMAC, byte[] ciphertext) throws IOException {
        return this.decodeCiphertext(receivedMAC, null, ciphertext);
    }

    private KeyParameter initRecordMAC(ChaChaEngine cipher) {
        byte[] firstBlock = new byte[64];
        cipher.processBytes(firstBlock, 0, firstBlock.length, firstBlock, 0);
        System.arraycopy(firstBlock, 0, firstBlock, 32, 16);
        KeyParameter macKey = new KeyParameter(firstBlock, 16, 32);
        Poly1305KeyGenerator.clamp((byte[])macKey.getKey());
        return macKey;
    }
}

