/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl.crypto;

import java.security.MessageDigest;
import java.security.PublicKey;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;

public class EdsaVerifier {
    private final PublicKey publicKey;

    public EdsaVerifier(byte[] publicKey) {
        EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName((String)"ed25519-sha-512");
        EdDSAPublicKeySpec pubKey = new EdDSAPublicKeySpec(publicKey, (EdDSAParameterSpec)spec);
        this.publicKey = new EdDSAPublicKey(pubKey);
    }

    public boolean verify(byte[] data, byte[] signature) throws Exception {
        EdDSAEngine sgr = new EdDSAEngine(MessageDigest.getInstance("SHA-512"));
        sgr.initVerify(this.publicKey);
        sgr.update(data);
        return sgr.verify(signature);
    }
}

