/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl.http.impl;

import io.github.hapjava.server.impl.http.HomekitClientConnection;
import io.github.hapjava.server.impl.http.HomekitClientConnectionFactory;
import io.github.hapjava.server.impl.http.HttpResponse;
import io.github.hapjava.server.impl.http.impl.BinaryHandler;
import io.github.hapjava.server.impl.http.impl.FullRequestHttpRequestImpl;
import io.github.hapjava.server.impl.http.impl.NettyResponseUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AccessoryHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessoryHandler.class);
    private HomekitClientConnection connection;
    private final HomekitClientConnectionFactory homekitClientConnectionFactory;

    public AccessoryHandler(HomekitClientConnectionFactory homekitClientConnectionFactory) {
        this.homekitClientConnectionFactory = homekitClientConnectionFactory;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.pipeline().channel();
        this.connection = this.homekitClientConnectionFactory.createConnection(response -> {
            if (!channel.isActive()) {
                return;
            }
            channel.writeAndFlush((Object)NettyResponseUtil.createResponse(response));
        });
        LOGGER.trace("New HomeKit connection from " + ctx.channel().remoteAddress().toString());
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        LOGGER.trace("Terminated HomeKit connection from " + ctx.channel().remoteAddress().toString());
        super.channelInactive(ctx);
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest req) throws Exception {
        try {
            HttpResponse response = this.connection.handleRequest(new FullRequestHttpRequestImpl(req));
            if (response.doUpgrade()) {
                ChannelPipeline pipeline = ctx.channel().pipeline();
                pipeline.addBefore("http", "binary", (ChannelHandler)new BinaryHandler(this.connection));
            }
            this.sendResponse(response, ctx);
        }
        catch (Exception e) {
            LOGGER.warn("Error handling homekit http request", (Throwable)e);
            this.sendResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR, "Error: " + e.getMessage(), ctx);
        }
    }

    private void sendResponse(HttpResponseStatus status, String responseBody, ChannelHandlerContext ctx) {
        if (responseBody == null) {
            responseBody = "";
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((byte[])responseBody.getBytes(StandardCharsets.UTF_8)));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        ctx.write((Object)response);
        ctx.flush();
    }

    private void sendResponse(HttpResponse homekitResponse, ChannelHandlerContext ctx) {
        FullHttpResponse response = NettyResponseUtil.createResponse(homekitResponse);
        ctx.write((Object)response);
        ctx.flush();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
        super.channelReadComplete(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        boolean errorLevel;
        boolean bl = errorLevel = !(cause instanceof IOException);
        if (errorLevel) {
            LOGGER.warn("Exception caught in web handler", cause);
        } else {
            LOGGER.debug("Exception caught in web handler", cause);
        }
        ctx.close();
    }
}

