/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl.http.impl;

import io.github.hapjava.server.HomekitWebHandler;
import io.github.hapjava.server.impl.http.HomekitClientConnectionFactory;
import io.github.hapjava.server.impl.http.impl.NettyHomekitHttpService;
import java.net.InetAddress;
import java.util.concurrent.CompletableFuture;

public class HomekitHttpServer
implements HomekitWebHandler {
    private NettyHomekitHttpService service = null;
    private final InetAddress localAddress;
    private final int port;
    private final int nThreads;

    @Override
    public void stop() {
        if (this.service != null) {
            this.service.shutdown();
        }
    }

    public HomekitHttpServer(InetAddress localAddress, int port, int nThreads) {
        this.localAddress = localAddress;
        this.port = port;
        this.nThreads = nThreads;
    }

    @Override
    public CompletableFuture<Integer> start(HomekitClientConnectionFactory clientConnectionFactory) {
        if (this.service == null) {
            this.service = NettyHomekitHttpService.create(this.localAddress, this.port, this.nThreads);
            return this.service.create(clientConnectionFactory);
        }
        throw new RuntimeException("HomekitHttpServer can only be started once");
    }

    @Override
    public void resetConnections() {
        this.service.resetConnections();
    }
}

