/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl.http.impl;

import io.github.hapjava.server.impl.http.HomekitClientConnectionFactory;
import io.github.hapjava.server.impl.http.impl.ServerInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NettyHomekitHttpService {
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private static final Logger logger = LoggerFactory.getLogger(NettyHomekitHttpService.class);
    private final ChannelGroup allChannels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private final InetAddress localAddress;
    private final int port;
    private final int nThreads;

    public static NettyHomekitHttpService create(InetAddress localAddress, int port, int nThreads) {
        return new NettyHomekitHttpService(localAddress, port, nThreads);
    }

    private NettyHomekitHttpService(InetAddress localAddress, int port, int nThreads) {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        this.localAddress = localAddress;
        this.port = port;
        this.nThreads = nThreads;
    }

    public CompletableFuture<Integer> create(HomekitClientConnectionFactory connectionFactory) {
        final CompletableFuture<Integer> portFuture = new CompletableFuture<Integer>();
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ServerInitializer(connectionFactory, this.allChannels, this.nThreads)).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        final ChannelFuture bindFuture = b.bind(this.localAddress, this.port);
        bindFuture.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> future) throws Exception {
                try {
                    future.get();
                    SocketAddress socketAddress = bindFuture.channel().localAddress();
                    if (!(socketAddress instanceof InetSocketAddress)) {
                        throw new RuntimeException("Unknown socket address type: " + socketAddress.getClass().getName());
                    }
                    logger.trace("Bound homekit listener to " + socketAddress.toString());
                    portFuture.complete(((InetSocketAddress)socketAddress).getPort());
                }
                catch (Exception e) {
                    portFuture.completeExceptionally(e);
                }
            }
        });
        return portFuture;
    }

    public void shutdown() {
        this.workerGroup.shutdownGracefully();
        this.bossGroup.shutdownGracefully();
    }

    public void resetConnections() {
        logger.trace("Resetting connections");
        this.allChannels.close();
    }
}

