/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl.http.impl;

import io.github.hapjava.server.impl.http.HomekitClientConnectionFactory;
import io.github.hapjava.server.impl.http.impl.AccessoryHandler;
import io.github.hapjava.server.impl.http.impl.HttpResponseEncoderAggregate;
import io.github.hapjava.server.impl.http.impl.LoggingHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;

class ServerInitializer
extends ChannelInitializer<SocketChannel> {
    private static final int MAX_POST = 1000000;
    public static final String HTTP_HANDLER_NAME = "http";
    private final HomekitClientConnectionFactory homekit;
    private final ChannelGroup allChannels;
    private final EventExecutorGroup blockingExecutorGroup;

    public ServerInitializer(HomekitClientConnectionFactory homekit, ChannelGroup allChannels, int nThreads) {
        this.homekit = homekit;
        this.allChannels = allChannels;
        this.blockingExecutorGroup = new DefaultEventExecutorGroup(nThreads);
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{new LoggingHandler()});
        pipeline.addLast(HTTP_HANDLER_NAME, (ChannelHandler)new HttpResponseEncoderAggregate());
        pipeline.addLast(new ChannelHandler[]{new HttpRequestDecoder()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(1000000)});
        pipeline.addLast(this.blockingExecutorGroup, new ChannelHandler[]{new AccessoryHandler(this.homekit)});
        this.allChannels.add((Object)ch);
    }
}

