/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl.json;

import io.github.hapjava.characteristics.Characteristic;
import io.github.hapjava.characteristics.EventableCharacteristic;
import io.github.hapjava.server.impl.HomekitRegistry;
import io.github.hapjava.server.impl.connections.SubscriptionManager;
import io.github.hapjava.server.impl.http.HomekitClientConnection;
import io.github.hapjava.server.impl.http.HttpRequest;
import io.github.hapjava.server.impl.http.HttpResponse;
import io.github.hapjava.server.impl.json.HapJsonNoContentResponse;
import io.github.hapjava.server.impl.json.HapJsonResponse;
import io.github.hapjava.server.impl.responses.NotFoundResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacteristicsController {
    Logger logger = LoggerFactory.getLogger(CharacteristicsController.class);
    private final HomekitRegistry registry;
    private final SubscriptionManager subscriptions;

    public CharacteristicsController(HomekitRegistry registry, SubscriptionManager subscriptions) {
        this.registry = registry;
        this.subscriptions = subscriptions;
    }

    public HttpResponse get(HttpRequest request) throws Exception {
        String uri = request.getUri();
        String query = uri.substring("/characteristics?id=".length());
        String[] ids = query.split(",");
        JsonArrayBuilder characteristics = Json.createArrayBuilder();
        for (String id : ids) {
            String[] parts = id.split("\\.");
            if (parts.length != 2) {
                this.logger.warn("Unexpected characteristics request: " + uri);
                return new NotFoundResponse();
            }
            int aid = Integer.parseInt(parts[0]);
            int iid = Integer.parseInt(parts[1]);
            JsonObjectBuilder characteristic = Json.createObjectBuilder();
            Map<Integer, Characteristic> characteristicMap = this.registry.getCharacteristics(aid);
            if (!characteristicMap.isEmpty()) {
                Characteristic targetCharacteristic = characteristicMap.get(iid);
                if (targetCharacteristic != null) {
                    targetCharacteristic.supplyValue(characteristic);
                    characteristics.add((JsonValue)characteristic.add("aid", aid).add("iid", iid).build());
                    continue;
                }
                this.logger.warn("Accessory " + aid + " does not have characteristic " + iid + ". Request: " + uri);
                continue;
            }
            this.logger.warn("Accessory " + aid + " has no characteristics or does not exist. Request: " + uri);
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            HapJsonResponse hapJsonResponse;
            block15: {
                JsonWriter jsonWriter = Json.createWriter((OutputStream)baos);
                try {
                    jsonWriter.write((JsonStructure)Json.createObjectBuilder().add("characteristics", (JsonValue)characteristics.build()).build());
                    hapJsonResponse = new HapJsonResponse(baos.toByteArray());
                    if (jsonWriter == null) break block15;
                }
                catch (Throwable throwable) {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonWriter.close();
            }
            return hapJsonResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HttpResponse put(HttpRequest request, HomekitClientConnection connection) throws Exception {
        this.subscriptions.batchUpdate();
        try (ByteArrayInputStream bais = new ByteArrayInputStream(request.getBody());){
            JsonArray jsonCharacteristics = Json.createReader((InputStream)bais).readObject().getJsonArray("characteristics");
            Iterator iterator = jsonCharacteristics.iterator();
            while (iterator.hasNext()) {
                JsonValue value = (JsonValue)iterator.next();
                JsonObject jsonCharacteristic = (JsonObject)value;
                int aid = jsonCharacteristic.getInt("aid");
                int iid = jsonCharacteristic.getInt("iid");
                Map<Integer, Characteristic> accessory = this.registry.getCharacteristics(aid);
                if (accessory.isEmpty()) {
                    this.logger.warn("Accessory {} has no characteristics or does not exist.", (Object)aid);
                    HapJsonNoContentResponse hapJsonNoContentResponse = new HapJsonNoContentResponse();
                    return hapJsonNoContentResponse;
                }
                Characteristic characteristic = accessory.get(iid);
                if (characteristic == null) {
                    this.logger.warn("Accessory {} does not have characteristic {}.", (Object)aid, (Object)iid);
                    HapJsonNoContentResponse hapJsonNoContentResponse = new HapJsonNoContentResponse();
                    return hapJsonNoContentResponse;
                }
                if (jsonCharacteristic.containsKey((Object)"value")) {
                    characteristic.setValue((JsonValue)jsonCharacteristic.get((Object)"value"));
                }
                if (!jsonCharacteristic.containsKey((Object)"ev") || !(characteristic instanceof EventableCharacteristic)) continue;
                if (jsonCharacteristic.getBoolean("ev")) {
                    this.subscriptions.addSubscription(aid, iid, (EventableCharacteristic)characteristic, connection);
                    continue;
                }
                this.subscriptions.removeSubscription((EventableCharacteristic)characteristic, connection);
            }
            return new HapJsonNoContentResponse();
        }
        finally {
            this.subscriptions.completeUpdateBatch();
        }
    }
}

