/*
 * Decompiled with CFR 0.152.
 */
package io.github.hapjava.server.impl.json;

import io.github.hapjava.characteristics.EventableCharacteristic;
import io.github.hapjava.server.impl.connections.PendingNotification;
import io.github.hapjava.server.impl.http.HttpResponse;
import io.github.hapjava.server.impl.json.EventResponse;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;

public class EventController {
    public HttpResponse getMessage(int accessoryId, int iid, EventableCharacteristic changed) throws Exception {
        JsonArrayBuilder characteristics = Json.createArrayBuilder();
        JsonObjectBuilder characteristicBuilder = Json.createObjectBuilder();
        characteristicBuilder.add("aid", accessoryId);
        characteristicBuilder.add("iid", iid);
        changed.supplyValue(characteristicBuilder);
        characteristics.add((JsonValue)characteristicBuilder.build());
        JsonObject data = Json.createObjectBuilder().add("characteristics", characteristics).build();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            EventResponse eventResponse;
            block11: {
                JsonWriter jsonWriter = Json.createWriter((OutputStream)baos);
                try {
                    jsonWriter.write((JsonStructure)data);
                    byte[] dataBytes = baos.toByteArray();
                    eventResponse = new EventResponse(dataBytes);
                    if (jsonWriter == null) break block11;
                }
                catch (Throwable throwable) {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonWriter.close();
            }
            return eventResponse;
        }
    }

    public HttpResponse getMessage(ArrayList<PendingNotification> notifications) throws Exception {
        JsonArrayBuilder characteristics = Json.createArrayBuilder();
        for (PendingNotification notification : notifications) {
            JsonObjectBuilder characteristicBuilder = Json.createObjectBuilder();
            characteristicBuilder.add("aid", notification.aid);
            characteristicBuilder.add("iid", notification.iid);
            notification.characteristic.supplyValue(characteristicBuilder);
            characteristics.add((JsonValue)characteristicBuilder.build());
        }
        JsonObject data = Json.createObjectBuilder().add("characteristics", characteristics).build();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            EventResponse eventResponse;
            block12: {
                JsonWriter jsonWriter = Json.createWriter((OutputStream)baos);
                try {
                    jsonWriter.write((JsonStructure)data);
                    byte[] dataBytes = baos.toByteArray();
                    eventResponse = new EventResponse(dataBytes);
                    if (jsonWriter == null) break block12;
                }
                catch (Throwable throwable) {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonWriter.close();
            }
            return eventResponse;
        }
    }
}

